/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.wan;

import java.io.DataInput;
import java.util.Arrays;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.serialization.ByteArrayDataInput;

public class EventSequenceID {
    private String membershipID;
    private long threadID;
    private long sequenceID;

    public EventSequenceID(byte[] membershipID, long threadID, long sequenceID) {
        Object mbr;
        try {
            mbr = InternalDistributedMember.readEssentialData((DataInput)new ByteArrayDataInput(membershipID));
        }
        catch (Exception e) {
            mbr = Arrays.toString(membershipID);
        }
        this.membershipID = mbr.toString();
        this.threadID = threadID;
        this.sequenceID = sequenceID;
    }

    public String getMembershipID() {
        return this.membershipID;
    }

    public long getThreadID() {
        return this.threadID;
    }

    public long getSequenceID() {
        return this.sequenceID;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EventSequenceID)) {
            return false;
        }
        EventSequenceID obj2 = (EventSequenceID)obj;
        return this.membershipID.equals(obj2.getMembershipID()) && this.threadID == obj2.getThreadID() && this.sequenceID == obj2.getSequenceID();
    }

    public int hashCode() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.membershipID);
        builder.append(this.threadID);
        builder.append(this.sequenceID);
        return builder.toString().hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("membershipID: " + this.membershipID);
        builder.append("; threadID: " + this.threadID);
        builder.append("; sequenceID: " + this.sequenceID);
        return builder.toString();
    }
}

