/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence.query.mock;

import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.persistence.query.CloseableIterator;
import org.apache.geode.internal.cache.persistence.query.IdentityExtractor;
import org.apache.geode.internal.cache.persistence.query.ResultSet;
import org.apache.geode.internal.cache.persistence.query.SortKeyExtractor;
import org.apache.geode.internal.cache.persistence.query.mock.SortedResultMapImpl;

public class SortedResultSetImpl
implements ResultSet {
    private final SortedResultMapImpl map;
    private SortKeyExtractor extractor;

    public SortedResultSetImpl(SortKeyExtractor extractor, boolean reverse) {
        this.extractor = extractor == null ? new IdentityExtractor() : extractor;
        this.map = new SortedResultMapImpl(reverse);
    }

    @Override
    public void add(Object e) {
        this.map.put(this.extractor.getSortKey(e), e);
    }

    @Override
    public CloseableIterator<CachedDeserializable> iterator() {
        return this.map.valueIterator();
    }

    @Override
    public void close() {
        this.map.close();
    }
}

