/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl;

import org.apache.hc.core5.http.ContentLengthStrategy;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.NotImplementedException;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.DefaultContentLengthStrategy;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.HeaderGroup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestDefaultContentLengthStrategy {
    TestDefaultContentLengthStrategy() {
    }

    @Test
    void testEntityWithChunkTransferEncoding() throws Exception {
        DefaultContentLengthStrategy lenStrategy = new DefaultContentLengthStrategy();
        TestHttpMessage message = new TestHttpMessage();
        message.addHeader("Transfer-Encoding", "Chunked");
        Assertions.assertEquals((long)-1L, (long)lenStrategy.determineLength((HttpMessage)message));
    }

    @Test
    void testEntityWithChunkTransferEncodingAndEmptyTokens() throws Exception {
        DefaultContentLengthStrategy lenStrategy = new DefaultContentLengthStrategy();
        TestHttpMessage message = new TestHttpMessage();
        message.addHeader("Transfer-Encoding", ",,Chunked,,");
        Assertions.assertEquals((long)-1L, (long)lenStrategy.determineLength((HttpMessage)message));
    }

    @Test
    void testEntityWithChunkTransferEncodingDoubleChunk() {
        DefaultContentLengthStrategy lenStrategy = new DefaultContentLengthStrategy();
        TestHttpMessage message = new TestHttpMessage();
        message.addHeader("Transfer-Encoding", "Chunked,Chunked");
        Assertions.assertThrows(NotImplementedException.class, () -> TestDefaultContentLengthStrategy.lambda$testEntityWithChunkTransferEncodingDoubleChunk$0((ContentLengthStrategy)lenStrategy, message));
    }

    @Test
    void testEntityWithChunkTransferEncodingUnknown1() {
        DefaultContentLengthStrategy lenStrategy = new DefaultContentLengthStrategy();
        TestHttpMessage message = new TestHttpMessage();
        message.addHeader("Transfer-Encoding", "blah");
        Assertions.assertThrows(NotImplementedException.class, () -> TestDefaultContentLengthStrategy.lambda$testEntityWithChunkTransferEncodingUnknown1$1((ContentLengthStrategy)lenStrategy, message));
    }

    @Test
    void testEntityWithChunkTransferEncodingUnknown2() {
        DefaultContentLengthStrategy lenStrategy = new DefaultContentLengthStrategy();
        TestHttpMessage message = new TestHttpMessage();
        message.addHeader("Transfer-Encoding", "blah, chunked");
        Assertions.assertThrows(NotImplementedException.class, () -> TestDefaultContentLengthStrategy.lambda$testEntityWithChunkTransferEncodingUnknown2$2((ContentLengthStrategy)lenStrategy, message));
    }

    @Test
    void testEntityWithChunkTransferEncodingUnknown3() {
        DefaultContentLengthStrategy lenStrategy = new DefaultContentLengthStrategy();
        TestHttpMessage message = new TestHttpMessage();
        message.addHeader("Transfer-Encoding", "chunked,blah");
        Assertions.assertThrows(NotImplementedException.class, () -> TestDefaultContentLengthStrategy.lambda$testEntityWithChunkTransferEncodingUnknown3$3((ContentLengthStrategy)lenStrategy, message));
    }

    @Test
    void testEntityWithIdentityTransferEncoding() {
        DefaultContentLengthStrategy lenStrategy = new DefaultContentLengthStrategy();
        TestHttpMessage message = new TestHttpMessage();
        message.addHeader("Transfer-Encoding", "Identity");
        Assertions.assertThrows(NotImplementedException.class, () -> TestDefaultContentLengthStrategy.lambda$testEntityWithIdentityTransferEncoding$4((ContentLengthStrategy)lenStrategy, message));
    }

    @Test
    void testEntityWithContentLength() throws Exception {
        DefaultContentLengthStrategy lenStrategy = new DefaultContentLengthStrategy();
        TestHttpMessage message = new TestHttpMessage();
        message.addHeader("Content-Length", "100");
        Assertions.assertEquals((long)100L, (long)lenStrategy.determineLength((HttpMessage)message));
    }

    @Test
    void testEntityWithInvalidContentLength() {
        DefaultContentLengthStrategy lenStrategy = new DefaultContentLengthStrategy();
        TestHttpMessage message = new TestHttpMessage();
        message.addHeader("Content-Length", "whatever");
        Assertions.assertThrows(ProtocolException.class, () -> TestDefaultContentLengthStrategy.lambda$testEntityWithInvalidContentLength$5((ContentLengthStrategy)lenStrategy, message));
    }

    @Test
    void testEntityWithNegativeContentLength() {
        DefaultContentLengthStrategy lenStrategy = new DefaultContentLengthStrategy();
        TestHttpMessage message = new TestHttpMessage();
        message.addHeader("Content-Length", "-10");
        Assertions.assertThrows(ProtocolException.class, () -> TestDefaultContentLengthStrategy.lambda$testEntityWithNegativeContentLength$6((ContentLengthStrategy)lenStrategy, message));
    }

    @Test
    void testEntityNoContentDelimiter() throws Exception {
        DefaultContentLengthStrategy lenStrategy = new DefaultContentLengthStrategy();
        TestHttpMessage message = new TestHttpMessage();
        Assertions.assertEquals((long)-9223372036854775807L, (long)lenStrategy.determineLength((HttpMessage)message));
    }

    private static /* synthetic */ void lambda$testEntityWithNegativeContentLength$6(ContentLengthStrategy lenStrategy, HttpMessage message) throws Throwable {
        lenStrategy.determineLength(message);
    }

    private static /* synthetic */ void lambda$testEntityWithInvalidContentLength$5(ContentLengthStrategy lenStrategy, HttpMessage message) throws Throwable {
        lenStrategy.determineLength(message);
    }

    private static /* synthetic */ void lambda$testEntityWithIdentityTransferEncoding$4(ContentLengthStrategy lenStrategy, HttpMessage message) throws Throwable {
        lenStrategy.determineLength(message);
    }

    private static /* synthetic */ void lambda$testEntityWithChunkTransferEncodingUnknown3$3(ContentLengthStrategy lenStrategy, HttpMessage message) throws Throwable {
        lenStrategy.determineLength(message);
    }

    private static /* synthetic */ void lambda$testEntityWithChunkTransferEncodingUnknown2$2(ContentLengthStrategy lenStrategy, HttpMessage message) throws Throwable {
        lenStrategy.determineLength(message);
    }

    private static /* synthetic */ void lambda$testEntityWithChunkTransferEncodingUnknown1$1(ContentLengthStrategy lenStrategy, HttpMessage message) throws Throwable {
        lenStrategy.determineLength(message);
    }

    private static /* synthetic */ void lambda$testEntityWithChunkTransferEncodingDoubleChunk$0(ContentLengthStrategy lenStrategy, HttpMessage message) throws Throwable {
        lenStrategy.determineLength(message);
    }

    static class TestHttpMessage
    extends HeaderGroup
    implements HttpMessage {
        private static final long serialVersionUID = 1L;

        TestHttpMessage() {
        }

        public ProtocolVersion getVersion() {
            return null;
        }

        public void addHeader(String name, Object value) {
            this.addHeader((Header)new BasicHeader(name, value));
        }

        public void setHeader(String name, Object value) {
            this.setHeader((Header)new BasicHeader(name, value));
        }

        public void setVersion(ProtocolVersion version) {
        }
    }
}

