/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.failure;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.ignite.Ignite;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public abstract class AbstractFailureHandler
implements FailureHandler {
    @GridToStringInclude
    private Set<FailureType> ignoredFailureTypes = Collections.unmodifiableSet(EnumSet.of(FailureType.SYSTEM_WORKER_BLOCKED, FailureType.SYSTEM_CRITICAL_OPERATION_TIMEOUT));

    public void setIgnoredFailureTypes(Set<FailureType> failureTypes) {
        this.ignoredFailureTypes = Collections.unmodifiableSet(failureTypes);
    }

    public Set<FailureType> getIgnoredFailureTypes() {
        return this.ignoredFailureTypes;
    }

    @Override
    public boolean onFailure(Ignite ignite, FailureContext failureCtx) {
        return !this.ignoredFailureTypes.contains((Object)failureCtx.type()) && this.handle(ignite, failureCtx);
    }

    protected abstract boolean handle(Ignite var1, FailureContext var2);

    public String toString() {
        return S.toString(AbstractFailureHandler.class, this);
    }
}

