/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.keys;

import java.sql.Time;
import java.time.LocalTime;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.DateValueUtils;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;

public class TimeIndexKey
implements IndexKey {
    private final long nanos;

    public TimeIndexKey(Object obj) {
        if (obj instanceof Date) {
            long millis = DateValueUtils.utcMillisFromDefaultTz(((Date)obj).getTime());
            if ((millis %= 86400000L) < 0L) {
                millis += 86400000L;
            }
            this.nanos = TimeUnit.MILLISECONDS.toNanos(millis);
        } else if (obj instanceof LocalTime) {
            LocalTime locTime = (LocalTime)obj;
            this.nanos = locTime.toNanoOfDay();
        } else {
            throw new IgniteException("Failed to convert object to time value, unexpected class " + obj.getClass().getName());
        }
    }

    public TimeIndexKey(long nanos) {
        this.nanos = nanos;
    }

    @Override
    public Object key() {
        long millis = TimeUnit.NANOSECONDS.toMillis(this.nanos);
        millis = DateValueUtils.defaultTzMillisFromUtc(millis);
        return new Time(millis);
    }

    public long nanos() {
        return this.nanos;
    }

    @Override
    public IndexKeyType type() {
        return IndexKeyType.TIME;
    }

    @Override
    public int compare(IndexKey o) {
        return Long.compare(this.nanos, ((TimeIndexKey)o).nanos);
    }

    public String toString() {
        return String.valueOf(this.nanos);
    }
}

