/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.internal.processors.cache.CachePartitionExchangeWorkerTask;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.jetbrains.annotations.Nullable;

class ClientCacheUpdateTimeout
extends GridTimeoutObjectAdapter
implements CachePartitionExchangeWorkerTask {
    private final GridCacheSharedContext cctx;
    @Nullable
    private final SecurityContext secCtx;

    ClientCacheUpdateTimeout(GridCacheSharedContext cctx, long timeout) {
        super(timeout);
        this.cctx = cctx;
        this.secCtx = SecurityUtils.remoteSecurityContext(cctx.kernalContext());
    }

    @Override
    public boolean skipForExchangeMerge() {
        return true;
    }

    @Override
    @Nullable
    public SecurityContext securityContext() {
        return this.secCtx;
    }

    @Override
    public void onTimeout() {
        if (!this.cctx.kernalContext().isStopping()) {
            this.cctx.exchange().addCustomTask(this);
        }
    }
}

