/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.parser.SqlParserPos;

public class SnowflakeSqlDialect
extends SqlDialect {
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.SNOWFLAKE).withIdentifierQuoteString("\"").withUnquotedCasing(Casing.TO_UPPER);
    public static final SqlDialect DEFAULT = new SnowflakeSqlDialect(DEFAULT_CONTEXT);

    public SnowflakeSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case BIT_AND: {
                SqlCall bitAndCall = SqlLibraryOperators.BITAND_AGG.createCall(SqlParserPos.ZERO, call.getOperandList());
                super.unparseCall(writer, bitAndCall, leftPrec, rightPrec);
                break;
            }
            case BIT_OR: {
                SqlCall bitOrCall = SqlLibraryOperators.BITOR_AGG.createCall(SqlParserPos.ZERO, call.getOperandList());
                super.unparseCall(writer, bitOrCall, leftPrec, rightPrec);
                break;
            }
            case CHAR_LENGTH: {
                SqlCall lengthCall = SqlLibraryOperators.LENGTH.createCall(SqlParserPos.ZERO, call.getOperandList());
                super.unparseCall(writer, lengthCall, leftPrec, rightPrec);
                break;
            }
            case ENDS_WITH: {
                SqlCall endsWithCall = SqlLibraryOperators.ENDSWITH.createCall(SqlParserPos.ZERO, call.getOperandList());
                super.unparseCall(writer, endsWithCall, leftPrec, rightPrec);
                break;
            }
            case STARTS_WITH: {
                SqlCall startsWithCall = SqlLibraryOperators.STARTSWITH.createCall(SqlParserPos.ZERO, call.getOperandList());
                super.unparseCall(writer, startsWithCall, leftPrec, rightPrec);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }

    @Override
    public boolean supportsApproxCountDistinct() {
        return true;
    }
}

