/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.server;

import org.apache.ignite.internal.raft.server.ReplicationGroupOptions;
import org.apache.ignite.internal.raft.storage.LogStorageFactory;
import org.apache.ignite.internal.raft.storage.RaftMetaStorageFactory;
import org.apache.ignite.internal.raft.storage.SnapshotStorageFactory;

public class RaftGroupOptions {
    private final boolean volatileStores;
    private LogStorageFactory logStorageFactory;
    private SnapshotStorageFactory snapshotStorageFactory;
    private RaftMetaStorageFactory raftMetaStorageFactory;
    private ReplicationGroupOptions replicationGroupOptions;

    public static RaftGroupOptions defaults() {
        return RaftGroupOptions.forPersistentStores();
    }

    public static RaftGroupOptions forPersistentStores() {
        return new RaftGroupOptions(false);
    }

    public static RaftGroupOptions forVolatileStores() {
        return new RaftGroupOptions(true);
    }

    private RaftGroupOptions(boolean volatileStores) {
        this.volatileStores = volatileStores;
    }

    public boolean volatileStores() {
        return this.volatileStores;
    }

    public LogStorageFactory getLogStorageFactory() {
        return this.logStorageFactory;
    }

    public RaftGroupOptions setLogStorageFactory(LogStorageFactory logStorageFactory) {
        this.logStorageFactory = logStorageFactory;
        return this;
    }

    public SnapshotStorageFactory snapshotStorageFactory() {
        return this.snapshotStorageFactory;
    }

    public RaftGroupOptions snapshotStorageFactory(SnapshotStorageFactory snapshotStorageFactory) {
        this.snapshotStorageFactory = snapshotStorageFactory;
        return this;
    }

    public RaftMetaStorageFactory raftMetaStorageFactory() {
        return this.raftMetaStorageFactory;
    }

    public RaftGroupOptions raftMetaStorageFactory(RaftMetaStorageFactory raftMetaStorageFactory) {
        this.raftMetaStorageFactory = raftMetaStorageFactory;
        return this;
    }

    public ReplicationGroupOptions replicationGroupOptions() {
        return this.replicationGroupOptions;
    }

    public RaftGroupOptions replicationGroupOptions(ReplicationGroupOptions replicationGroupOptions) {
        this.replicationGroupOptions = replicationGroupOptions;
        return this;
    }
}

