/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.util;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.configuration.SuperRoot;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.NamedListNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.configuration.util.KeysTrackingConfigurationVisitor;

public class ConfigurationFlattener {
    public static Map<String, Serializable> createFlattenedUpdatesMap(SuperRoot curRoot, SuperRoot updates) {
        HashMap<String, Serializable> resMap = new HashMap<String, Serializable>();
        ArrayDeque<InnerNode> oldInnerNodesStack = new ArrayDeque<InnerNode>();
        oldInnerNodesStack.push(curRoot);
        updates.traverseChildren(new FlattenerVisitor(oldInnerNodesStack, resMap), true);
        assert (oldInnerNodesStack.peek() == curRoot) : oldInnerNodesStack;
        return resMap;
    }

    private static Map<String, Integer> keysToOrderIdx(NamedListNode<?> node) {
        HashMap<String, Integer> res = new HashMap<String, Integer>();
        int idx = 0;
        for (String key : node.namedListKeys()) {
            if (node.getInnerNode(key) == null) continue;
            res.put(key, idx++);
        }
        return res;
    }

    private static class FlattenerVisitor
    extends KeysTrackingConfigurationVisitor<Object> {
        private final Deque<InnerNode> oldInnerNodesStack;
        private final Map<String, Serializable> resMap;
        private boolean singleTreeTraversal;
        private boolean deletion;

        FlattenerVisitor(Deque<InnerNode> oldInnerNodesStack, Map<String, Serializable> resMap) {
            this.oldInnerNodesStack = oldInnerNodesStack;
            this.resMap = resMap;
        }

        @Override
        public Void doVisitLeafNode(Field field, String key, Serializable newVal) {
            Serializable oldVal = this.oldInnerNodesStack.element().traverseChild(key, ConfigurationUtil.leafNodeVisitor(), true);
            if (this.singleTreeTraversal || !Objects.deepEquals(oldVal, newVal)) {
                this.resMap.put(this.currentKey(), this.deletion ? null : newVal);
            }
            return null;
        }

        @Override
        public Void doVisitInnerNode(Field field, String key, InnerNode newNode) {
            InnerNode oldNode = this.oldInnerNodesStack.element().traverseChild(key, ConfigurationUtil.innerNodeVisitor(), true);
            if (oldNode == newNode && !this.singleTreeTraversal) {
                return null;
            }
            if (oldNode == null && newNode == null) {
                return null;
            }
            if (oldNode == null) {
                this.visitAsymmetricInnerNode(newNode, false);
            } else if (oldNode.schemaType() != newNode.schemaType()) {
                this.visitAsymmetricInnerNode(oldNode, true);
                this.visitAsymmetricInnerNode(newNode, false);
            } else {
                this.oldInnerNodesStack.push(oldNode);
                newNode.traverseChildren(this, true);
                this.oldInnerNodesStack.pop();
            }
            return null;
        }

        @Override
        public Void doVisitNamedListNode(Field field, String key, NamedListNode<?> newNode) {
            NamedListNode<?> oldNode = this.oldInnerNodesStack.element().traverseChild(key, ConfigurationUtil.namedListNodeVisitor(), true);
            if (oldNode == newNode && !this.singleTreeTraversal) {
                return null;
            }
            Map<String, Integer> oldKeysToOrderIdxMap = this.singleTreeTraversal ? null : ConfigurationFlattener.keysToOrderIdx(oldNode);
            Map<String, Integer> newKeysToOrderIdxMap = this.deletion ? null : ConfigurationFlattener.keysToOrderIdx(newNode);
            for (String newNodeKey : newNode.namedListKeys()) {
                UUID newNodeInternalId = newNode.internalId(newNodeKey);
                String namedListFullKey = this.currentKey();
                this.withTracking(newNodeInternalId.toString(), false, false, () -> {
                    Integer oldIdx;
                    InnerNode newNamedElement = newNode.getInnerNode(newNodeKey);
                    String oldNodeKey = oldNode.keyByInternalId(newNodeInternalId);
                    InnerNode oldNamedElement = oldNode.getInnerNode(oldNodeKey);
                    if (oldNamedElement == null && newNamedElement == null) {
                        return null;
                    }
                    if (this.singleTreeTraversal || oldNamedElement != newNamedElement) {
                        if (newNamedElement == null) {
                            this.visitAsymmetricInnerNode(oldNamedElement, true);
                        } else if (oldNamedElement == null) {
                            this.visitAsymmetricInnerNode(newNamedElement, false);
                        } else if (newNamedElement.schemaType() != oldNamedElement.schemaType()) {
                            this.visitAsymmetricInnerNode(oldNamedElement, true);
                            this.visitAsymmetricInnerNode(newNamedElement, false);
                        } else {
                            this.oldInnerNodesStack.push(oldNamedElement);
                            newNamedElement.traverseChildren(this, true);
                            this.oldInnerNodesStack.pop();
                        }
                    }
                    Integer newIdx = newKeysToOrderIdxMap == null ? null : (Integer)newKeysToOrderIdxMap.get(newNodeKey);
                    Integer n = oldIdx = oldKeysToOrderIdxMap == null ? null : (Integer)oldKeysToOrderIdxMap.get(newNodeKey);
                    if (!Objects.equals(newIdx, oldIdx) || this.singleTreeTraversal || newNamedElement == null) {
                        String orderKey = this.currentKey() + "<order>";
                        this.resMap.put(orderKey, this.deletion || newNamedElement == null ? null : newIdx);
                    }
                    if (this.singleTreeTraversal || oldNamedElement == null || newNamedElement == null || !oldNodeKey.equals(newNodeKey)) {
                        String nameKey = this.currentKey() + "<name>";
                        this.resMap.put(nameKey, (Serializable)((Object)(this.deletion || newNamedElement == null ? null : newNodeKey)));
                    }
                    if (this.singleTreeTraversal) {
                        if (this.deletion) {
                            this.resMap.put(this.idKey(namedListFullKey, oldNodeKey), null);
                        } else {
                            this.resMap.put(this.idKey(namedListFullKey, newNodeKey), newNodeInternalId);
                        }
                    } else if (newNamedElement == null) {
                        this.resMap.put(this.idKey(namedListFullKey, oldNodeKey), null);
                    } else if (oldNamedElement == null) {
                        this.resMap.put(this.idKey(namedListFullKey, newNodeKey), newNodeInternalId);
                    } else if (!oldNodeKey.equals(newNodeKey)) {
                        this.resMap.put(this.idKey(namedListFullKey, oldNodeKey), null);
                        this.resMap.put(this.idKey(namedListFullKey, newNodeKey), newNodeInternalId);
                    }
                    return null;
                });
            }
            return null;
        }

        private String idKey(String prefix, String nodeKey) {
            return prefix + "<ids>." + ConfigurationUtil.escape(nodeKey);
        }

        private void visitAsymmetricInnerNode(InnerNode node, boolean delete) {
            assert (!this.singleTreeTraversal);
            assert (node != null);
            this.oldInnerNodesStack.push(node);
            this.singleTreeTraversal = true;
            this.deletion = delete;
            node.traverseChildren(this, true);
            this.deletion = false;
            this.singleTreeTraversal = false;
            this.oldInnerNodesStack.pop();
        }
    }
}

