/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class WriteSpeedFormatter {
    private static final DecimalFormatSymbols SEPARATOR = new DecimalFormatSymbols();
    private static final DecimalFormat HIGH_SPEED_FORMAT;
    private static final DecimalFormat MEDIUM_SPEED_FORMAT;
    private static final DecimalFormat LOW_SPEED_FORMAT;

    private WriteSpeedFormatter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatWriteSpeed(float avgWriteSpeedInBytes) {
        float speedInMbs = avgWriteSpeedInBytes / 1048576.0f;
        if ((double)speedInMbs >= 10.0) {
            DecimalFormat decimalFormat = HIGH_SPEED_FORMAT;
            synchronized (decimalFormat) {
                return HIGH_SPEED_FORMAT.format(speedInMbs);
            }
        }
        if ((double)speedInMbs >= 0.1) {
            DecimalFormat decimalFormat = MEDIUM_SPEED_FORMAT;
            synchronized (decimalFormat) {
                return MEDIUM_SPEED_FORMAT.format(speedInMbs);
            }
        }
        DecimalFormat decimalFormat = LOW_SPEED_FORMAT;
        synchronized (decimalFormat) {
            return LOW_SPEED_FORMAT.format(speedInMbs);
        }
    }

    static {
        SEPARATOR.setDecimalSeparator('.');
        HIGH_SPEED_FORMAT = new DecimalFormat("#", SEPARATOR);
        MEDIUM_SPEED_FORMAT = new DecimalFormat("#.##", SEPARATOR);
        LOW_SPEED_FORMAT = new DecimalFormat("#.####", SEPARATOR);
    }
}

