/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoop;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.OutNetworkObject;
import org.apache.ignite.internal.network.message.ClusterNodeMessage;
import org.apache.ignite.internal.network.netty.ChannelEventLoopsSource;
import org.apache.ignite.internal.network.netty.ChannelKey;
import org.apache.ignite.internal.network.netty.NettySender;
import org.apache.ignite.internal.network.netty.NettyUtils;
import org.apache.ignite.internal.network.recovery.message.HandshakeRejectedMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeRejectionReason;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.network.ClusterNode;

class HandshakeManagerUtils {
    private static final IgniteLogger LOG = Loggers.forClass(HandshakeManagerUtils.class);
    private static final NetworkMessagesFactory MESSAGE_FACTORY = new NetworkMessagesFactory();

    HandshakeManagerUtils() {
    }

    static void sendRejectionMessageAndFailHandshake(String message, HandshakeRejectionReason rejectionReason, Channel channel, CompletableFuture<NettySender> handshakeFuture, Function<String, Exception> exceptionFactory) {
        HandshakeManagerUtils.sendRejectionMessageAndFailHandshake(message, message, rejectionReason, channel, handshakeFuture, exceptionFactory);
    }

    static void sendRejectionMessageAndFailHandshake(String exceptionText, String messageText, HandshakeRejectionReason rejectionReason, Channel channel, CompletableFuture<NettySender> handshakeFuture, Function<String, Exception> exceptionFactory) {
        HandshakeRejectedMessage rejectionMessage = MESSAGE_FACTORY.handshakeRejectedMessage().reasonString(rejectionReason.name()).message(messageText).build();
        ChannelFuture sendFuture = channel.writeAndFlush((Object)new OutNetworkObject(rejectionMessage, Collections.emptyList(), false));
        NettyUtils.toCompletableFuture(sendFuture).whenComplete((unused, ex) -> handshakeFuture.completeExceptionally((Throwable)exceptionFactory.apply(exceptionText)));
    }

    static void switchEventLoopIfNeeded(Channel channel, ChannelKey channelKey, ChannelEventLoopsSource eventLoopsSource, Runnable afterSwitching) {
        EventLoop targetEventLoop = HandshakeManagerUtils.eventLoopForKey(channelKey, eventLoopsSource);
        if (targetEventLoop != channel.eventLoop()) {
            channel.deregister().addListener(deregistrationFuture -> {
                if (!deregistrationFuture.isSuccess()) {
                    LOG.error("Cannot deregister a channel from an event loop", deregistrationFuture.cause());
                    channel.close();
                    return;
                }
                targetEventLoop.register(channel).addListener(registrationFuture -> {
                    if (!registrationFuture.isSuccess()) {
                        LOG.error("Cannot register a channel with an event loop", registrationFuture.cause());
                        channel.close();
                        return;
                    }
                    afterSwitching.run();
                });
            });
        } else {
            afterSwitching.run();
        }
    }

    private static EventLoop eventLoopForKey(ChannelKey channelKey, ChannelEventLoopsSource eventLoopsSource) {
        List<EventLoop> eventLoops = eventLoopsSource.channelEventLoops();
        int index = IgniteUtils.safeAbs((int)channelKey.hashCode()) % eventLoops.size();
        return eventLoops.get(index);
    }

    static ClusterNodeMessage clusterNodeToMessage(ClusterNode node) {
        return MESSAGE_FACTORY.clusterNodeMessage().id(node.id()).name(node.name()).host(node.address().host()).port(node.address().port()).build();
    }
}

