/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine;

import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.exec.AsyncDataCursor;
import org.apache.ignite.internal.util.AsyncCursor;
import org.apache.ignite.sql.ResultSetMetadata;
import org.jetbrains.annotations.Nullable;

public class AsyncSqlCursorImpl<T>
implements AsyncSqlCursor<T> {
    private final SqlQueryType queryType;
    private final ResultSetMetadata meta;
    private final AsyncDataCursor<T> dataCursor;
    @Nullable
    private final CompletableFuture<AsyncSqlCursor<T>> nextStatement;

    public AsyncSqlCursorImpl(SqlQueryType queryType, ResultSetMetadata meta, AsyncDataCursor<T> dataCursor, @Nullable CompletableFuture<AsyncSqlCursor<T>> nextStatement) {
        this.queryType = queryType;
        this.meta = meta;
        this.dataCursor = dataCursor;
        this.nextStatement = nextStatement;
    }

    @Override
    public SqlQueryType queryType() {
        return this.queryType;
    }

    @Override
    public ResultSetMetadata metadata() {
        return this.meta;
    }

    public CompletableFuture<AsyncCursor.BatchedResult<T>> requestNextAsync(int rows) {
        return this.dataCursor.requestNextAsync(rows);
    }

    @Override
    public boolean hasNextResult() {
        return this.nextStatement != null;
    }

    @Override
    public CompletableFuture<AsyncSqlCursor<T>> nextResult() {
        if (this.nextStatement == null) {
            throw new NoSuchElementException("Query has no more results");
        }
        return this.nextStatement;
    }

    public CompletableFuture<Void> closeAsync() {
        return this.dataCursor.closeAsync();
    }

    @Override
    public CompletableFuture<Void> onClose() {
        return this.dataCursor.onClose();
    }

    @Override
    public CompletableFuture<Void> onFirstPageReady() {
        return this.dataCursor.onFirstPageReady();
    }
}

