/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.metaservice;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bifromq.basecrdt.service.ICRDTService;
import org.apache.bifromq.basekv.metaservice.BaseKVLandscapeCRDT;
import org.apache.bifromq.basekv.metaservice.BaseKVLandscapeObserver;
import org.apache.bifromq.basekv.metaservice.BaseKVLandscapeReporter;
import org.apache.bifromq.basekv.metaservice.BaseKVStoreBalancerStatesCRDT;
import org.apache.bifromq.basekv.metaservice.BaseKVStoreBalancerStatesObserver;
import org.apache.bifromq.basekv.metaservice.BaseKVStoreBalancerStatesProposal;
import org.apache.bifromq.basekv.metaservice.BaseKVStoreBalancerStatesProposalCRDT;
import org.apache.bifromq.basekv.metaservice.BaseKVStoreBalancerStatesProposer;
import org.apache.bifromq.basekv.metaservice.BaseKVStoreBalancerStatesReporter;
import org.apache.bifromq.basekv.metaservice.CRDTUtil;
import org.apache.bifromq.basekv.metaservice.IBaseKVLandscapeCRDT;
import org.apache.bifromq.basekv.metaservice.IBaseKVLandscapeObserver;
import org.apache.bifromq.basekv.metaservice.IBaseKVLandscapeReporter;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.basekv.metaservice.IBaseKVStoreBalancerStatesCRDT;
import org.apache.bifromq.basekv.metaservice.IBaseKVStoreBalancerStatesObserver;
import org.apache.bifromq.basekv.metaservice.IBaseKVStoreBalancerStatesProposal;
import org.apache.bifromq.basekv.metaservice.IBaseKVStoreBalancerStatesProposalCRDT;
import org.apache.bifromq.basekv.metaservice.IBaseKVStoreBalancerStatesProposer;
import org.apache.bifromq.basekv.metaservice.IBaseKVStoreBalancerStatesReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BaseKVMetaService
implements IBaseKVMetaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseKVMetaService.class);
    private final ICRDTService crdtService;
    private final Map<String, IBaseKVLandscapeCRDT> landscapeCRDTs = new ConcurrentHashMap<String, IBaseKVLandscapeCRDT>();
    private final Map<String, IBaseKVStoreBalancerStatesCRDT> balancerStatesCRDTs = new ConcurrentHashMap<String, IBaseKVStoreBalancerStatesCRDT>();
    private final Map<String, IBaseKVStoreBalancerStatesProposalCRDT> balancerStatesProposalCRDTs = new ConcurrentHashMap<String, IBaseKVStoreBalancerStatesProposalCRDT>();

    BaseKVMetaService(ICRDTService crdtService) {
        this.crdtService = crdtService;
    }

    @Override
    public Observable<Set<String>> clusterIds() {
        return this.crdtService.aliveCRDTs().map(crdtUris -> crdtUris.stream().filter(CRDTUtil::isLandscapeURI).map(CRDTUtil::parseClusterId).collect(Collectors.toSet())).distinctUntilChanged().observeOn(Schedulers.single());
    }

    @Override
    public IBaseKVStoreBalancerStatesProposer balancerStatesProposer(String clusterId) {
        IBaseKVStoreBalancerStatesProposalCRDT statesCRDT = this.balancerStatesProposalCRDTs.computeIfAbsent(clusterId, k -> new BaseKVStoreBalancerStatesProposalCRDT(clusterId, this.crdtService));
        return new BaseKVStoreBalancerStatesProposer(statesCRDT);
    }

    @Override
    public IBaseKVStoreBalancerStatesProposal balancerStatesProposal(String clusterId) {
        IBaseKVStoreBalancerStatesProposalCRDT statesCRDT = this.balancerStatesProposalCRDTs.computeIfAbsent(clusterId, k -> new BaseKVStoreBalancerStatesProposalCRDT(clusterId, this.crdtService));
        return new BaseKVStoreBalancerStatesProposal(statesCRDT);
    }

    @Override
    public IBaseKVLandscapeObserver landscapeObserver(String clusterId) {
        IBaseKVLandscapeCRDT landscapeCRDT = this.landscapeCRDTs.computeIfAbsent(clusterId, k -> new BaseKVLandscapeCRDT(clusterId, this.crdtService));
        return new BaseKVLandscapeObserver(landscapeCRDT);
    }

    @Override
    public IBaseKVLandscapeReporter landscapeReporter(String clusterId, String storeId) {
        IBaseKVLandscapeCRDT landscapeCRDT = this.landscapeCRDTs.computeIfAbsent(clusterId, k -> new BaseKVLandscapeCRDT(clusterId, this.crdtService));
        return new BaseKVLandscapeReporter(storeId, landscapeCRDT);
    }

    @Override
    public IBaseKVStoreBalancerStatesObserver balancerStatesObserver(String clusterId) {
        IBaseKVStoreBalancerStatesCRDT balancerStatesCRDT = this.balancerStatesCRDTs.computeIfAbsent(clusterId, k -> new BaseKVStoreBalancerStatesCRDT(clusterId, this.crdtService));
        return new BaseKVStoreBalancerStatesObserver(balancerStatesCRDT);
    }

    @Override
    public IBaseKVStoreBalancerStatesReporter balancerStatesReporter(String clusterId, String storeId) {
        IBaseKVStoreBalancerStatesCRDT balancerStatesCRDT = this.balancerStatesCRDTs.computeIfAbsent(clusterId, k -> new BaseKVStoreBalancerStatesCRDT(clusterId, this.crdtService));
        return new BaseKVStoreBalancerStatesReporter(storeId, balancerStatesCRDT);
    }

    @Override
    public void close() {
        this.landscapeCRDTs.values().forEach(IBaseKVLandscapeCRDT::stop);
        this.balancerStatesCRDTs.values().forEach(IBaseKVStoreBalancerStatesCRDT::stop);
        this.balancerStatesProposalCRDTs.values().forEach(IBaseKVStoreBalancerStatesProposalCRDT::stop);
    }
}

