/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler;

import com.google.common.util.concurrent.RateLimiter;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.bifromq.mqtt.handler.ChannelAttrs;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.eventcollector.ThreadLocalEventPool;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.channelclosed.ChannelError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ConnectionRateLimitHandler
extends ChannelDuplexHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectionRateLimitHandler.class);
    private final RateLimiter rateLimiter;
    private final IEventCollector eventCollector;
    private final ChannelPipelineInitializer initializer;
    private boolean accepted = false;

    public ConnectionRateLimitHandler(RateLimiter limiter, IEventCollector eventCollector, ChannelPipelineInitializer initializer) {
        this.rateLimiter = limiter;
        this.eventCollector = eventCollector;
        this.initializer = initializer;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        if (this.rateLimiter.tryAcquire()) {
            this.accepted = true;
            this.initializer.initialize(ctx.pipeline());
            ctx.fireChannelActive();
            ctx.pipeline().remove((ChannelHandler)this);
        } else {
            this.accepted = false;
            log.debug("Connection dropped due to exceed limit");
            this.eventCollector.report((Event)((ChannelError)((ChannelError)ThreadLocalEventPool.getLocal(ChannelError.class)).peerAddress(ChannelAttrs.socketAddress(ctx.channel()))).cause((Throwable)new RuntimeException("Reject connection due to conn rate limiting")));
            ctx.channel().config().setAutoRead(false);
            ctx.executor().schedule(() -> {
                if (ctx.channel().isActive()) {
                    ctx.close();
                }
            }, ThreadLocalRandom.current().nextLong(100L, 3000L), TimeUnit.MILLISECONDS);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (!this.accepted) {
            ReferenceCountUtil.release((Object)msg);
            return;
        }
        ctx.fireChannelRead(msg);
    }

    public static interface ChannelPipelineInitializer {
        public void initialize(ChannelPipeline var1);
    }
}

