/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.rsc.rpc;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.Closeable;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.security.SecureRandom;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.livy.rsc.RSCConf;
import org.apache.livy.rsc.Utils;
import org.apache.livy.rsc.rpc.Rpc;
import org.apache.livy.rsc.rpc.RpcDispatcher;
import org.apache.livy.rsc.rpc.SaslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcServer
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(RpcServer.class);
    private static final SecureRandom RND = new SecureRandom();
    private final String address;
    private Channel channel;
    private final EventLoopGroup group;
    private final int port;
    private final ConcurrentMap<String, ClientInfo> pendingClients;
    private final RSCConf config;
    private final String portRange;
    private final String PORT_DELIMITER = "~";

    public RpcServer(RSCConf lconf) throws IOException, InterruptedException {
        this.config = lconf;
        this.portRange = this.config.get(RSCConf.Entry.LAUNCHER_PORT_RANGE);
        this.group = new NioEventLoopGroup(this.config.getInt(RSCConf.Entry.RPC_MAX_THREADS), Utils.newDaemonThreadFactory("RPC-Handler-%d"));
        int[] portData = this.getPortNumberAndRange();
        int startingPortNumber = portData[PortRangeSchema.START_PORT.ordinal()];
        int endPort = portData[PortRangeSchema.END_PORT.ordinal()];
        boolean isContected = false;
        for (int tries = startingPortNumber; tries <= endPort; ++tries) {
            try {
                this.channel = this.getChannel(tries);
                isContected = true;
                break;
            }
            catch (SocketException e) {
                LOG.debug("RPC not able to connect port " + tries + " " + e.getMessage());
                continue;
            }
        }
        if (!isContected) {
            throw new IOException("Unable to connect to provided ports " + this.portRange);
        }
        this.port = ((InetSocketAddress)this.channel.localAddress()).getPort();
        this.pendingClients = new ConcurrentHashMap<String, ClientInfo>();
        LOG.info("Connected to the port " + this.port);
        String address = this.config.get(RSCConf.Entry.RPC_SERVER_ADDRESS);
        if (address == null) {
            address = this.config.findLocalAddress();
        }
        this.address = address;
    }

    private int[] getPortNumberAndRange() throws ArrayIndexOutOfBoundsException, NumberFormatException {
        String[] split = this.portRange.split("~");
        int[] portRange = new int[PortRangeSchema.MAX.ordinal()];
        try {
            portRange[PortRangeSchema.START_PORT.ordinal()] = Integer.parseInt(split[PortRangeSchema.START_PORT.ordinal()]);
            portRange[PortRangeSchema.END_PORT.ordinal()] = Integer.parseInt(split[PortRangeSchema.END_PORT.ordinal()]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOG.error("Port Range format is not correct " + this.portRange);
            throw e;
        }
        catch (NumberFormatException e) {
            LOG.error("Port are not in numeric format " + this.portRange);
            throw e;
        }
        return portRange;
    }

    private Channel getChannel(int portNumber) throws BindException, InterruptedException {
        Channel channel = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                SaslServerHandler saslHandler = new SaslServerHandler(RpcServer.this.config);
                final Rpc newRpc = Rpc.createServer(saslHandler, RpcServer.this.config, ch, (EventExecutorGroup)RpcServer.this.group);
                saslHandler.rpc = newRpc;
                Runnable cancelTask = new Runnable(){

                    @Override
                    public void run() {
                        LOG.warn("Timed out waiting for hello from client.");
                        newRpc.close();
                    }
                };
                saslHandler.cancelTask = RpcServer.this.group.schedule(cancelTask, RpcServer.this.config.getTimeAsMs(RSCConf.Entry.RPC_CLIENT_HANDSHAKE_TIMEOUT), TimeUnit.MILLISECONDS);
            }
        }).option(ChannelOption.SO_BACKLOG, (Object)1)).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).bind(portNumber).sync().channel();
        return channel;
    }

    public void registerClient(String clientId, String secret, ClientCallback callback) {
        ClientInfo client = new ClientInfo(clientId, secret, callback);
        if (this.pendingClients.putIfAbsent(clientId, client) != null) {
            throw new IllegalStateException(String.format("Client '%s' already registered.", clientId));
        }
    }

    public void unregisterClient(String clientId) {
        this.pendingClients.remove(clientId);
    }

    public String createSecret() {
        byte[] secret = new byte[this.config.getInt(RSCConf.Entry.RPC_SECRET_RANDOM_BITS) / 8];
        RND.nextBytes(secret);
        StringBuilder sb = new StringBuilder();
        for (byte b : secret) {
            if (b < 10) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(b));
        }
        return sb.toString();
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.channel.close();
            this.pendingClients.clear();
        }
        finally {
            this.group.shutdownGracefully();
        }
    }

    private static class ClientInfo {
        final String id;
        final String secret;
        final ClientCallback callback;

        private ClientInfo(String id, String secret, ClientCallback callback) {
            this.id = id;
            this.secret = secret;
            this.callback = callback;
        }
    }

    private class SaslServerHandler
    extends SaslHandler
    implements CallbackHandler {
        private final SaslServer server;
        private Rpc rpc;
        private ScheduledFuture<?> cancelTask;
        private String clientId;
        private ClientInfo client;

        SaslServerHandler(RSCConf config) throws IOException {
            super(config);
            this.server = Sasl.createSaslServer(config.get(RSCConf.Entry.SASL_MECHANISMS), "rsc", "rsc", config.getSaslOptions(), this);
        }

        @Override
        protected boolean isComplete() {
            return this.server.isComplete();
        }

        @Override
        protected String getNegotiatedProperty(String name) {
            return (String)this.server.getNegotiatedProperty(name);
        }

        @Override
        protected Rpc.SaslMessage update(Rpc.SaslMessage challenge) throws IOException {
            if (this.clientId == null) {
                Utils.checkArgument(challenge.clientId != null, "Missing client ID in SASL handshake.", new Object[0]);
                this.clientId = challenge.clientId;
                this.client = (ClientInfo)RpcServer.this.pendingClients.get(this.clientId);
                Utils.checkArgument(this.client != null, "Unexpected client ID '%s' in SASL handshake.", this.clientId);
            }
            return new Rpc.SaslMessage(this.server.evaluateResponse(challenge.payload));
        }

        @Override
        public byte[] wrap(byte[] data, int offset, int len) throws IOException {
            return this.server.wrap(data, offset, len);
        }

        @Override
        public byte[] unwrap(byte[] data, int offset, int len) throws IOException {
            return this.server.unwrap(data, offset, len);
        }

        @Override
        public void dispose() throws IOException {
            if (!this.server.isComplete()) {
                this.onError(new SaslException("Server closed before SASL negotiation finished."));
            }
            this.server.dispose();
        }

        @Override
        protected void onComplete() throws Exception {
            this.cancelTask.cancel(true);
            RpcDispatcher dispatcher = null;
            try {
                dispatcher = this.client.callback.onNewClient(this.rpc);
            }
            catch (Exception e) {
                LOG.warn("Client callback threw an exception.", (Throwable)e);
            }
            if (dispatcher != null) {
                this.rpc.setDispatcher(dispatcher);
            }
            this.client.callback.onSaslComplete(this.rpc);
        }

        @Override
        protected void onError(Throwable error) {
            this.cancelTask.cancel(true);
        }

        @Override
        public void handle(Callback[] callbacks) {
            Utils.checkState(this.client != null, "Handshake not initialized yet.", new Object[0]);
            for (Callback cb : callbacks) {
                if (cb instanceof NameCallback) {
                    ((NameCallback)cb).setName(this.clientId);
                    continue;
                }
                if (cb instanceof PasswordCallback) {
                    ((PasswordCallback)cb).setPassword(this.client.secret.toCharArray());
                    continue;
                }
                if (cb instanceof AuthorizeCallback) {
                    ((AuthorizeCallback)cb).setAuthorized(true);
                    continue;
                }
                if (!(cb instanceof RealmCallback)) continue;
                RealmCallback rb = (RealmCallback)cb;
                rb.setText(rb.getDefaultText());
            }
        }
    }

    public static interface ClientCallback {
        public RpcDispatcher onNewClient(Rpc var1);

        public void onSaslComplete(Rpc var1);
    }

    private static enum PortRangeSchema {
        START_PORT,
        END_PORT,
        MAX;

    }
}

