/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.rsc.driver;

import com.fasterxml.jackson.annotation.JsonRawValue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.livy.rsc.driver.StatementState;

public class Statement {
    public final Integer id;
    public final String code;
    public final AtomicReference<StatementState> state;
    @JsonRawValue
    public volatile String output;
    public double progress;

    public Statement(Integer id, String code, StatementState state, String output) {
        this.id = id;
        this.code = code;
        this.state = new AtomicReference<StatementState>(state);
        this.output = output;
        this.progress = 0.0;
    }

    public Statement() {
        this(null, null, null, null);
    }

    public boolean compareAndTransit(StatementState from, StatementState to) {
        if (this.state.compareAndSet(from, to)) {
            StatementState.validate(from, to);
            return true;
        }
        return false;
    }

    public void updateProgress(double p) {
        this.progress = this.state.get().isOneOf(StatementState.Cancelled, StatementState.Available) ? 1.0 : p;
    }
}

