/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.repl;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.livy.client.common.ClientConf;
import org.apache.livy.repl.SparkRInterpreter;
import org.apache.livy.rsc.driver.SparkEntries;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SQLContext;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.api.JavaMirrors;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.matching.UnanchoredRegex;

public final class SparkRInterpreter$ {
    public static final SparkRInterpreter$ MODULE$;
    private final String LIVY_END_MARKER;
    private final String org$apache$livy$repl$SparkRInterpreter$$LIVY_ERROR_MARKER;
    private final String org$apache$livy$repl$SparkRInterpreter$$PRINT_MARKER;
    private final String org$apache$livy$repl$SparkRInterpreter$$EXPECTED_OUTPUT;
    private SparkEntries sparkEntries;
    private final UnanchoredRegex org$apache$livy$repl$SparkRInterpreter$$PLOT_REGEX;

    static {
        new SparkRInterpreter$();
    }

    private String LIVY_END_MARKER() {
        return this.LIVY_END_MARKER;
    }

    public String org$apache$livy$repl$SparkRInterpreter$$LIVY_ERROR_MARKER() {
        return this.org$apache$livy$repl$SparkRInterpreter$$LIVY_ERROR_MARKER;
    }

    public String org$apache$livy$repl$SparkRInterpreter$$PRINT_MARKER() {
        return this.org$apache$livy$repl$SparkRInterpreter$$PRINT_MARKER;
    }

    public String org$apache$livy$repl$SparkRInterpreter$$EXPECTED_OUTPUT() {
        return this.org$apache$livy$repl$SparkRInterpreter$$EXPECTED_OUTPUT;
    }

    private SparkEntries sparkEntries() {
        return this.sparkEntries;
    }

    private void sparkEntries_$eq(SparkEntries x$1) {
        this.sparkEntries = x$1;
    }

    public UnanchoredRegex org$apache$livy$repl$SparkRInterpreter$$PLOT_REGEX() {
        return this.org$apache$livy$repl$SparkRInterpreter$$PLOT_REGEX;
    }

    public SparkRInterpreter apply(SparkConf conf, SparkEntries entries) {
        this.sparkEntries_$eq(entries);
        int backendTimeout = new StringOps(Predef$.MODULE$.augmentString((String)scala.sys.package$.MODULE$.env().getOrElse((Object)"SPARKR_BACKEND_TIMEOUT", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "120";
            }
        }))).toInt();
        JavaMirrors.JavaMirror mirror = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        Class<?> sparkRBackendClass = mirror.classLoader().loadClass("org.apache.spark.api.r.RBackend");
        Object backendInstance = sparkRBackendClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        IntRef sparkRBackendPort = new IntRef(0);
        Semaphore initialized = new Semaphore(0);
        Thread backendThread = new Thread(sparkRBackendClass, backendInstance, sparkRBackendPort, initialized){
            private final Class sparkRBackendClass$1;
            private final Object backendInstance$1;
            private final IntRef sparkRBackendPort$1;
            private final Semaphore initialized$1;

            public void run() {
                this.sparkRBackendPort$1.elem = BoxesRunTime.unboxToInt((Object)this.sparkRBackendClass$1.getMethod("init", new Class[0]).invoke(this.backendInstance$1, new Object[0]));
                this.initialized$1.release();
                this.sparkRBackendClass$1.getMethod("run", new Class[0]).invoke(this.backendInstance$1, new Object[0]);
            }
            {
                this.sparkRBackendClass$1 = sparkRBackendClass$1;
                this.backendInstance$1 = backendInstance$1;
                this.sparkRBackendPort$1 = sparkRBackendPort$1;
                this.initialized$1 = initialized$1;
                super("SparkR backend");
            }
        };
        backendThread.setDaemon(true);
        backendThread.start();
        try {
            initialized.tryAcquire(backendTimeout, TimeUnit.SECONDS);
            String rExec = (String)conf.getOption("spark.r.shell.command").orElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return scala.sys.package$.MODULE$.env().get((Object)"SPARKR_DRIVER_R");
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "R";
                }
            });
            String packageDir = "";
            Object object = scala.sys.package$.MODULE$.env().getOrElse((Object)"SPARK_YARN_MODE", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            });
            String string = "true";
            if (!(object != null ? !object.equals(string) : string != null)) {
                packageDir = "./sparkr";
            } else {
                File rLibPath = new File((String)scala.sys.package$.MODULE$.env().getOrElse((Object)"SPARKR_PACKAGE_DIR", (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)scala.sys.package$.MODULE$.env().getOrElse((Object)"SPARK_HOME", (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return ".";
                            }
                        }), "R", "lib"}))).mkString(File.separator);
                    }
                }));
                if (!ClientConf.TEST_MODE) {
                    Predef$.MODULE$.require(rLibPath.exists(), (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Cannot find sparkr package directory.";
                        }
                    });
                    packageDir = rLibPath.getAbsolutePath();
                }
            }
            ProcessBuilder builder = new ProcessBuilder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{rExec, "--slave @"}))).asJava());
            Map<String, String> env = builder.environment();
            env.put("SPARK_HOME", (String)scala.sys.package$.MODULE$.env().getOrElse((Object)"SPARK_HOME", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return ".";
                }
            }));
            env.put("EXISTING_SPARKR_BACKEND_PORT", ((Object)BoxesRunTime.boxToInteger((int)sparkRBackendPort.elem)).toString());
            env.put("SPARKR_PACKAGE_DIR", packageDir);
            env.put("R_PROFILE_USER", ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{packageDir, "SparkR", "profile", "general.R"}))).mkString(File.separator));
            builder.redirectErrorStream(true);
            Process process = builder.start();
            return new SparkRInterpreter(process, backendInstance, backendThread, conf.getInt("spark.livy.spark_major_version", 1));
        }
        catch (Exception exception) {
            if (backendThread != null) {
                backendThread.interrupt();
            }
            throw exception;
        }
    }

    public JavaSparkContext getSparkContext() {
        Predef$.MODULE$.require(this.sparkEntries() != null);
        return this.sparkEntries().sc();
    }

    public Object getSparkSession() {
        Predef$.MODULE$.require(this.sparkEntries() != null);
        return this.sparkEntries().sparkSession();
    }

    public SQLContext getSQLContext() {
        Predef$.MODULE$.require(this.sparkEntries() != null);
        return this.sparkEntries().hivectx() == null ? this.sparkEntries().sqlctx() : this.sparkEntries().hivectx();
    }

    private SparkRInterpreter$() {
        MODULE$ = this;
        this.LIVY_END_MARKER = "----LIVY_END_OF_COMMAND----";
        this.org$apache$livy$repl$SparkRInterpreter$$LIVY_ERROR_MARKER = "----LIVY_END_OF_ERROR----";
        String arg$1 = this.LIVY_END_MARKER();
        this.org$apache$livy$repl$SparkRInterpreter$$PRINT_MARKER = new StringOps(Predef$.MODULE$.augmentString("print(\"%s\")")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$1}));
        String arg$2 = this.LIVY_END_MARKER();
        this.org$apache$livy$repl$SparkRInterpreter$$EXPECTED_OUTPUT = new StringOps(Predef$.MODULE$.augmentString("[1] \"%s\"")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$2}));
        this.sparkEntries = null;
        this.org$apache$livy$repl$SparkRInterpreter$$PLOT_REGEX = new StringOps(Predef$.MODULE$.augmentString("((?:bagplot)|(?:barplot)|(?:boxplot)|(?:dotchart)|(?:hist)|(?:lines)|(?:pie)|(?:pie3D)|(?:plot)|(?:qqline)|(?:qqnorm)|(?:scatterplot)|(?:scatterplot3d)|(?:scatterplot\\.matrix)|(?:splom)|(?:stripchart)|(?:vioplot))")).r().unanchored();
    }
}

