/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.session;

import org.apache.livy.thriftserver.session.DataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;

final class SparkUtils {
    SparkUtils() {
    }

    public static DataType[] translateSchema(StructType schema) {
        DataType[] types = new DataType[schema.fields().length];
        int idx = 0;
        for (StructField f : schema.fields()) {
            org.apache.spark.sql.types.DataType ftype = f.dataType();
            types[idx] = ftype instanceof BooleanType ? DataType.BOOLEAN : (ftype instanceof ByteType ? DataType.BYTE : (ftype instanceof ShortType ? DataType.SHORT : (ftype instanceof IntegerType ? DataType.INTEGER : (ftype instanceof LongType ? DataType.LONG : (ftype instanceof FloatType ? DataType.FLOAT : (ftype instanceof DoubleType ? DataType.DOUBLE : (ftype instanceof BinaryType ? DataType.BINARY : DataType.STRING)))))));
            ++idx;
        }
        return types;
    }

    public static StructType dataTypesToSchema(DataType[] types) {
        StructField[] fields = new StructField[types.length];
        int idx = 0;
        for (DataType dt : types) {
            org.apache.spark.sql.types.DataType sparkDt = null;
            switch (dt) {
                case BOOLEAN: {
                    sparkDt = DataTypes.BooleanType;
                    break;
                }
                case BYTE: {
                    sparkDt = DataTypes.ByteType;
                    break;
                }
                case SHORT: {
                    sparkDt = DataTypes.ShortType;
                    break;
                }
                case INTEGER: {
                    sparkDt = DataTypes.IntegerType;
                    break;
                }
                case LONG: {
                    sparkDt = DataTypes.LongType;
                    break;
                }
                case FLOAT: {
                    sparkDt = DataTypes.FloatType;
                    break;
                }
                case DOUBLE: {
                    sparkDt = DataTypes.DoubleType;
                    break;
                }
                case BINARY: {
                    sparkDt = DataTypes.BinaryType;
                    break;
                }
                case STRING: {
                    sparkDt = DataTypes.StringType;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid data type: " + (Object)((Object)dt));
                }
            }
            fields[idx] = new StructField("col_" + idx, sparkDt, true, Metadata.empty());
            ++idx;
        }
        return new StructType(fields);
    }

    public static int toJavaSQLType(org.apache.spark.sql.types.DataType type) {
        if (type instanceof NullType) {
            return 0;
        }
        if (type instanceof BooleanType) {
            return 16;
        }
        if (type instanceof ByteType) {
            return -6;
        }
        if (type instanceof ShortType) {
            return 5;
        }
        if (type instanceof IntegerType) {
            return 4;
        }
        if (type instanceof LongType) {
            return -5;
        }
        if (type instanceof FloatType) {
            return 6;
        }
        if (type instanceof DoubleType) {
            return 8;
        }
        if (type instanceof StringType) {
            return 12;
        }
        if (type instanceof DecimalType) {
            return 3;
        }
        if (type instanceof DateType) {
            return 91;
        }
        if (type instanceof TimestampType) {
            return 93;
        }
        if (type instanceof BinaryType) {
            return -2;
        }
        if (type instanceof ArrayType) {
            return 2003;
        }
        if (type instanceof MapType) {
            return 2000;
        }
        if (type instanceof StructType) {
            return 2002;
        }
        return 1111;
    }

    public static Integer getColumnSize(org.apache.spark.sql.types.DataType type) {
        if (type instanceof ByteType) {
            return 3;
        }
        if (type instanceof ShortType) {
            return 5;
        }
        if (type instanceof IntegerType) {
            return 10;
        }
        if (type instanceof LongType) {
            return 19;
        }
        if (type instanceof FloatType) {
            return 7;
        }
        if (type instanceof DoubleType) {
            return 15;
        }
        if (type instanceof DecimalType) {
            return ((DecimalType)type).precision();
        }
        if (type instanceof StringType || type instanceof BinaryType || type instanceof MapType || type instanceof ArrayType || type instanceof StructType) {
            return Integer.MAX_VALUE;
        }
        if (type instanceof DateType) {
            return 10;
        }
        if (type instanceof TimestampType) {
            return 29;
        }
        return null;
    }

    public static Integer getDecimalDigits(org.apache.spark.sql.types.DataType type) {
        if (type instanceof BooleanType || type instanceof ByteType || type instanceof ShortType || type instanceof IntegerType || type instanceof LongType) {
            return 0;
        }
        if (type instanceof FloatType) {
            return 7;
        }
        if (type instanceof DoubleType) {
            return 15;
        }
        if (type instanceof DecimalType) {
            return ((DecimalType)type).scale();
        }
        if (type instanceof TimestampType) {
            return 9;
        }
        return null;
    }

    public static Integer getNumPrecRadix(org.apache.spark.sql.types.DataType type) {
        if (type instanceof ByteType || type instanceof ShortType || type instanceof IntegerType || type instanceof LongType || type instanceof FloatType || type instanceof DoubleType || type instanceof DecimalType) {
            return 10;
        }
        return null;
    }
}

