/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.channels.SocketChannel;
import java.util.Locale;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.client.io.ConnectPromise;
import org.eclipse.jetty.websocket.client.io.WebSocketClientSelectorManager;
import org.eclipse.jetty.websocket.common.events.EventDriver;

public class ConnectionManager
extends ContainerLifeCycle {
    private static final Logger LOG = Log.getLogger(ConnectionManager.class);
    private final WebSocketClient client;
    private WebSocketClientSelectorManager selector;

    public static InetSocketAddress toSocketAddress(URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("Cannot get InetSocketAddress of non-absolute URIs");
        }
        int port = uri.getPort();
        String scheme = uri.getScheme().toLowerCase(Locale.ENGLISH);
        if ("ws".equals(scheme)) {
            if (port == -1) {
                port = 80;
            }
        } else if ("wss".equals(scheme)) {
            if (port == -1) {
                port = 443;
            }
        } else {
            throw new IllegalArgumentException("Only support ws:// and wss:// URIs");
        }
        return new InetSocketAddress(uri.getHost(), port);
    }

    public ConnectionManager(WebSocketClient client) {
        this.client = client;
    }

    public ConnectPromise connect(WebSocketClient client, EventDriver driver, ClientUpgradeRequest request) {
        return new PhysicalConnect(client, driver, request);
    }

    @Override
    protected void doStart() throws Exception {
        this.selector = this.newWebSocketClientSelectorManager(this.client);
        this.selector.setSslContextFactory(this.client.getSslContextFactory());
        this.selector.setConnectTimeout(this.client.getConnectTimeout());
        this.addBean(this.selector);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this.selector);
    }

    public WebSocketClientSelectorManager getSelector() {
        return this.selector;
    }

    protected WebSocketClientSelectorManager newWebSocketClientSelectorManager(WebSocketClient client) {
        return new WebSocketClientSelectorManager(client);
    }

    private class PhysicalConnect
    extends ConnectPromise {
        private SocketAddress bindAddress;

        public PhysicalConnect(WebSocketClient client, EventDriver driver, ClientUpgradeRequest request) {
            super(client, driver, request);
            this.bindAddress = client.getBindAddress();
        }

        @Override
        public void run() {
            SocketChannel channel = null;
            try {
                channel = SocketChannel.open();
                if (this.bindAddress != null) {
                    channel.bind(this.bindAddress);
                }
                URI wsUri = this.getRequest().getRequestURI();
                channel.socket().setTcpNoDelay(true);
                channel.configureBlocking(false);
                InetSocketAddress address = ConnectionManager.toSocketAddress(wsUri);
                if (channel.connect(address)) {
                    ConnectionManager.this.getSelector().accept(channel, this);
                } else {
                    ConnectionManager.this.getSelector().connect(channel, this);
                }
            }
            catch (Throwable t) {
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException ignore) {
                        LOG.ignore(ignore);
                    }
                }
                this.failed(t);
            }
        }
    }
}

