/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.session;

import java.util.ArrayList;
import java.util.List;
import org.apache.livy.thriftserver.session.DataType;
import org.apache.livy.thriftserver.session.SparkCatalogJob;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.expressions.GenericRow;
import scala.Tuple2;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class GetFunctionsJob
extends SparkCatalogJob {
    private static final char SEARCH_STRING_ESCAPE = '\\';
    private final String databasePattern;
    private final String functionRegex;

    public GetFunctionsJob(String databasePattern, String functionSQLSearch, String sessionId, String jobId, DataType[] resultTypes) {
        super(sessionId, jobId, resultTypes);
        this.databasePattern = this.convertSchemaPattern(databasePattern);
        this.functionRegex = this.patternToRegex(functionSQLSearch);
    }

    @Override
    protected List<Row> fetchCatalogObjects(SessionCatalog catalog) {
        ArrayList<Row> funcList = new ArrayList<Row>();
        List databases = JavaConversions.seqAsJavaList((Seq)catalog.listDatabases(this.databasePattern));
        for (String db : databases) {
            List identifiersTypes = JavaConversions.seqAsJavaList((Seq)catalog.listFunctions(db, this.functionRegex));
            for (Tuple2 identifierType : identifiersTypes) {
                FunctionIdentifier function = (FunctionIdentifier)identifierType._1;
                ExpressionInfo info = catalog.lookupFunctionInfo(function);
                funcList.add((Row)new GenericRow(new Object[]{null, function.database().isDefined() ? function.database().get() : null, function.funcName(), info.getUsage() + info.getExtended(), null, info.getClassName()}));
            }
        }
        return funcList;
    }

    private String patternToRegex(String pattern) {
        if (pattern == null) {
            return ".*";
        }
        StringBuilder result = new StringBuilder(pattern.length());
        boolean escaped = false;
        int len = pattern.length();
        for (int i = 0; i < len; ++i) {
            char c = pattern.charAt(i);
            if (escaped) {
                if (c != '\\') {
                    escaped = false;
                }
                result.append(c);
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '%') {
                result.append(".*");
                continue;
            }
            if (c == '_') {
                result.append('.');
                continue;
            }
            result.append(Character.toLowerCase(c));
        }
        return result.toString();
    }
}

