/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import java.util.Comparator;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.constant.CompactionPriority;
import org.apache.iotdb.db.engine.compaction.cross.AbstractCrossSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.inner.AbstractInnerSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;

public class CompactionTaskComparator
implements Comparator<AbstractCompactionTask> {
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    @Override
    public int compare(AbstractCompactionTask o1, AbstractCompactionTask o2) {
        if (o1 instanceof AbstractInnerSpaceCompactionTask && o2 instanceof AbstractCrossSpaceCompactionTask || o2 instanceof AbstractInnerSpaceCompactionTask && o1 instanceof AbstractCrossSpaceCompactionTask) {
            if (this.config.getCompactionPriority() == CompactionPriority.BALANCE) {
                return 0;
            }
            if (this.config.getCompactionPriority() == CompactionPriority.INNER_CROSS) {
                return o1 instanceof AbstractInnerSpaceCompactionTask ? -1 : 1;
            }
            return o1 instanceof AbstractCrossSpaceCompactionTask ? -1 : 1;
        }
        if (o1 instanceof AbstractInnerSpaceCompactionTask) {
            return this.compareInnerSpaceCompactionTask((AbstractInnerSpaceCompactionTask)o1, (AbstractInnerSpaceCompactionTask)o2);
        }
        return this.compareCrossSpaceCompactionTask((AbstractCrossSpaceCompactionTask)o1, (AbstractCrossSpaceCompactionTask)o2);
    }

    private int compareInnerSpaceCompactionTask(AbstractInnerSpaceCompactionTask o1, AbstractInnerSpaceCompactionTask o2) {
        if (o1.isSequence() ^ o2.isSequence()) {
            return o1.isSequence() ? -1 : 1;
        }
        if ((double)o1.getSumOfCompactionCount() / (double)o1.getSelectedTsFileResourceList().size() != (double)o2.getSumOfCompactionCount() / (double)o2.getSelectedTsFileResourceList().size()) {
            return o1.getSumOfCompactionCount() / o1.getSelectedTsFileResourceList().size() - o2.getSumOfCompactionCount() / o2.getSelectedTsFileResourceList().size();
        }
        if (o1.getMaxFileVersion() != o2.getMaxFileVersion()) {
            return o2.getMaxFileVersion() > o1.getMaxFileVersion() ? 1 : -1;
        }
        List<TsFileResource> selectedFilesOfO1 = o1.getSelectedTsFileResourceList();
        List<TsFileResource> selectedFilesOfO2 = o2.getSelectedTsFileResourceList();
        if (selectedFilesOfO1.size() != selectedFilesOfO2.size()) {
            return selectedFilesOfO2.size() - selectedFilesOfO1.size();
        }
        if (o1.getSelectedFileSize() != o2.getSelectedFileSize()) {
            return (int)(o1.getSelectedFileSize() - o2.getSelectedFileSize());
        }
        return 0;
    }

    private int compareCrossSpaceCompactionTask(AbstractCrossSpaceCompactionTask o1, AbstractCrossSpaceCompactionTask o2) {
        if (o1.getSelectedSequenceFiles().size() != o2.getSelectedSequenceFiles().size()) {
            return o1.getSelectedSequenceFiles().size() - o2.getSelectedSequenceFiles().size();
        }
        return o2.getSelectedUnsequenceFiles().size() - o1.getSelectedUnsequenceFiles().size();
    }
}

