/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.last;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.db.queryengine.execution.aggregation.Aggregator;
import org.apache.iotdb.db.queryengine.execution.aggregation.LastValueDescAccumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.MaxTimeDescAccumulator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.filter.operator.TimeFilterOperators;
import org.apache.tsfile.utils.Binary;

public class LastQueryUtil {
    private static final boolean CACHE_ENABLED = CommonDescriptor.getInstance().getConfig().isLastCacheEnable();

    private LastQueryUtil() {
    }

    public static TsBlockBuilder createTsBlockBuilder() {
        return new TsBlockBuilder((List)ImmutableList.of((Object)TSDataType.TEXT, (Object)TSDataType.TEXT, (Object)TSDataType.TEXT));
    }

    public static TsBlockBuilder createTsBlockBuilder(int initialExpectedEntries) {
        return new TsBlockBuilder(initialExpectedEntries, (List)ImmutableList.of((Object)TSDataType.TEXT, (Object)TSDataType.TEXT, (Object)TSDataType.TEXT));
    }

    public static Binary getTimeSeries(TsBlock tsBlock, int index) {
        return tsBlock.getColumn(0).getBinary(index);
    }

    public static void appendLastValue(TsBlockBuilder builder, long lastTime, String fullPath, String lastValue, String dataType) {
        builder.getTimeColumnBuilder().writeLong(lastTime);
        builder.getColumnBuilder(0).writeBinary(new Binary(fullPath, TSFileConfig.STRING_CHARSET));
        builder.getColumnBuilder(1).writeBinary(new Binary(lastValue, TSFileConfig.STRING_CHARSET));
        builder.getColumnBuilder(2).writeBinary(new Binary(dataType, TSFileConfig.STRING_CHARSET));
        builder.declarePosition();
    }

    public static void appendLastValue(TsBlockBuilder builder, long lastTime, Binary fullPath, String lastValue, String dataType) {
        builder.getTimeColumnBuilder().writeLong(lastTime);
        builder.getColumnBuilder(0).writeBinary(fullPath);
        builder.getColumnBuilder(1).writeBinary(new Binary(lastValue, TSFileConfig.STRING_CHARSET));
        builder.getColumnBuilder(2).writeBinary(new Binary(dataType, TSFileConfig.STRING_CHARSET));
        builder.declarePosition();
    }

    public static void appendLastValue(TsBlockBuilder builder, TsBlock tsBlock) {
        if (tsBlock.isEmpty()) {
            return;
        }
        int size = tsBlock.getPositionCount();
        for (int i = 0; i < size; ++i) {
            builder.getTimeColumnBuilder().writeLong(tsBlock.getTimeByIndex(i));
            builder.getColumnBuilder(0).writeBinary(tsBlock.getColumn(0).getBinary(i));
            builder.getColumnBuilder(1).writeBinary(tsBlock.getColumn(1).getBinary(i));
            builder.getColumnBuilder(2).writeBinary(tsBlock.getColumn(2).getBinary(i));
            builder.declarePosition();
        }
    }

    public static void appendLastValue(TsBlockBuilder builder, TsBlock tsBlock, int index) {
        builder.getTimeColumnBuilder().writeLong(tsBlock.getTimeByIndex(index));
        builder.getColumnBuilder(0).writeBinary(tsBlock.getColumn(0).getBinary(index));
        builder.getColumnBuilder(1).writeBinary(tsBlock.getColumn(1).getBinary(index));
        builder.getColumnBuilder(2).writeBinary(tsBlock.getColumn(2).getBinary(index));
        builder.declarePosition();
    }

    public static int compareTimeSeries(TsBlock a, int indexA, TsBlock b, int indexB, Comparator<Binary> comparator) {
        return comparator.compare(a.getColumn(0).getBinary(indexA), b.getColumn(0).getBinary(indexB));
    }

    public static boolean satisfyFilter(Filter filter, TimeValuePair tvPair) {
        return filter == null || filter.satisfy(tvPair.getTimestamp(), tvPair.getValue().getValue());
    }

    public static List<Aggregator> createAggregators(TSDataType dataType) {
        ArrayList<Aggregator> aggregators = new ArrayList<Aggregator>(2);
        aggregators.add(new Aggregator(new MaxTimeDescAccumulator(), AggregationStep.SINGLE, Collections.singletonList(new InputLocation[]{new InputLocation(0, 0)})));
        aggregators.add(new Aggregator(new LastValueDescAccumulator(dataType), AggregationStep.SINGLE, Collections.singletonList(new InputLocation[]{new InputLocation(0, 0)})));
        return aggregators;
    }

    public static List<Aggregator> createAggregators(TSDataType dataType, int valueColumnIndex) {
        ArrayList<Aggregator> aggregators = new ArrayList<Aggregator>(2);
        aggregators.add(new Aggregator(new MaxTimeDescAccumulator(), AggregationStep.SINGLE, Collections.singletonList(new InputLocation[]{new InputLocation(0, valueColumnIndex)})));
        aggregators.add(new Aggregator(new LastValueDescAccumulator(dataType), AggregationStep.SINGLE, Collections.singletonList(new InputLocation[]{new InputLocation(0, valueColumnIndex)})));
        return aggregators;
    }

    public static boolean needUpdateCache(Filter timeFilter) {
        return CACHE_ENABLED && (timeFilter == null || timeFilter instanceof TimeFilterOperators.TimeGtEq || timeFilter instanceof TimeFilterOperators.TimeGt);
    }

    public static boolean needUpdateNullEntry(Filter timeFilter) {
        return CACHE_ENABLED && timeFilter == null;
    }

    public static class LastEntry {
        private final long time;
        private final Binary timeSeries;
        private final Binary value;
        private final Binary dataType;

        public LastEntry(long time, Binary timeSeries, Binary value, Binary dataType) {
            this.time = time;
            this.timeSeries = timeSeries;
            this.value = value;
            this.dataType = dataType;
        }

        public LastEntry(TsBlock tsBlock, int index) {
            this.time = tsBlock.getTimeByIndex(index);
            this.timeSeries = tsBlock.getColumn(0).getBinary(index);
            this.value = tsBlock.getColumn(1).getBinary(index);
            this.dataType = tsBlock.getColumn(2).getBinary(index);
        }

        public long getTime() {
            return this.time;
        }

        public Binary getTimeSeries() {
            return this.timeSeries;
        }

        public Binary getValue() {
            return this.value;
        }

        public Binary getDataType() {
            return this.dataType;
        }
    }
}

