/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DataType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DataTypeParameter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;

public final class GenericDataType
extends DataType {
    private final Identifier name;
    private final List<DataTypeParameter> arguments;

    public GenericDataType(Identifier name, List<DataTypeParameter> arguments) {
        super(null);
        this.name = Objects.requireNonNull(name, "name is null");
        this.arguments = Objects.requireNonNull(arguments, "arguments is null");
    }

    public GenericDataType(@Nonnull NodeLocation location, Identifier name, List<DataTypeParameter> arguments) {
        super(Objects.requireNonNull(location, "location is null"));
        this.name = Objects.requireNonNull(name, "name is null");
        this.arguments = Objects.requireNonNull(arguments, "arguments is null");
    }

    public Identifier getName() {
        return this.name;
    }

    public List<DataTypeParameter> getArguments() {
        return this.arguments;
    }

    public List<Node> getChildren() {
        return ImmutableList.builder().add((Object)this.name).addAll(this.arguments).build();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGenericDataType(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericDataType that = (GenericDataType)o;
        return this.name.equals(that.name) && this.arguments.equals(that.arguments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.arguments);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return GenericDataType.sameClass(this, other);
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.GENERIC_DATA_TYPE;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        GenericDataType.serialize((Expression)this.name, stream);
    }

    public GenericDataType(ByteBuffer byteBuffer) {
        super(null);
        this.name = (Identifier)GenericDataType.deserialize(byteBuffer);
        this.arguments = Collections.emptyList();
    }
}

