/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.tag;

import java.io.File;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagLogFile
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TagLogFile.class);
    private File tagFile;
    private FileChannel fileChannel;
    private static final String LENGTH_EXCEED_MSG = "Tag/Attribute exceeds the max length limit. Please enlarge tag_attribute_total_size in iotdb-system.properties";
    private static final int MAX_LENGTH = CommonDescriptor.getInstance().getConfig().getTagAttributeTotalSize();
    private static final int RECORD_FLUSH_INTERVAL = IoTDBDescriptor.getInstance().getConfig().getTagAttributeFlushInterval();
    private int unFlushedRecordNum = 0;

    public TagLogFile(String schemaDir, String logFileName) throws IOException {
        File metadataDir = SystemFileFactory.INSTANCE.getFile(schemaDir);
        if (!metadataDir.exists()) {
            if (metadataDir.mkdirs()) {
                logger.info("create schema folder {}.", (Object)metadataDir);
            } else {
                logger.info("create schema folder {} failed.", (Object)metadataDir);
            }
        }
        this.tagFile = SystemFileFactory.INSTANCE.getFile(schemaDir + File.separator + logFileName);
        this.fileChannel = FileChannel.open(this.tagFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        try {
            this.fileChannel.position(this.fileChannel.size());
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            // empty catch block
        }
    }

    public synchronized void copyTo(File targetFile) throws IOException {
        this.fileChannel.force(true);
        FileUtils.copyFile((File)this.tagFile, (File)targetFile);
    }

    public Pair<Map<String, String>, Map<String, String>> read(long position) throws IOException {
        if (position < 0L) {
            return new Pair(Collections.emptyMap(), Collections.emptyMap());
        }
        ByteBuffer byteBuffer = TagLogFile.parseByteBuffer(this.fileChannel, position);
        return new Pair((Object)ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer), (Object)ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer));
    }

    public Map<String, String> readTag(long position) throws IOException {
        ByteBuffer byteBuffer = TagLogFile.parseByteBuffer(this.fileChannel, position);
        return ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer);
    }

    public static ByteBuffer parseByteBuffer(FileChannel fileChannel, long position) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(MAX_LENGTH);
        fileChannel.read(byteBuffer, position);
        byteBuffer.flip();
        if (byteBuffer.limit() > 0) {
            int firstInt = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            byteBuffer.position(0);
            if (firstInt < -1) {
                int blockNum = -firstInt;
                ByteBuffer byteBuffers = ByteBuffer.allocate(blockNum * MAX_LENGTH);
                byteBuffers.put(byteBuffer);
                byteBuffers.position(4);
                for (int i = 1; i < blockNum; ++i) {
                    long nextPosition = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffers);
                    byteBuffers.position(MAX_LENGTH * i);
                    byteBuffers.limit(MAX_LENGTH * (i + 1));
                    fileChannel.read(byteBuffers, nextPosition);
                    byteBuffers.position(4 + i * 8);
                }
                byteBuffers.limit(byteBuffers.capacity());
                return byteBuffers;
            }
        }
        return byteBuffer;
    }

    private List<Long> parseOffsetList(long position) throws IOException {
        ArrayList<Long> blockOffset = new ArrayList<Long>();
        blockOffset.add(position);
        ByteBuffer byteBuffer = ByteBuffer.allocate(MAX_LENGTH);
        this.fileChannel.read(byteBuffer, position);
        byteBuffer.flip();
        if (byteBuffer.limit() > 0) {
            int firstInt = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            byteBuffer.position(0);
            if (firstInt < -1) {
                int blockNum = -firstInt;
                int blockOffsetStoreLen = (((blockNum - 1) * 8 + 4) / MAX_LENGTH + 1) * MAX_LENGTH;
                ByteBuffer blockBuffer = ByteBuffer.allocate(blockOffsetStoreLen);
                blockBuffer.put(byteBuffer);
                blockBuffer.position(4);
                for (int i = 1; i < blockNum; ++i) {
                    blockOffset.add(ReadWriteIOUtils.readLong((ByteBuffer)blockBuffer));
                    if (MAX_LENGTH * (i + 1) > blockOffsetStoreLen) continue;
                    blockBuffer.position(MAX_LENGTH * i);
                    blockBuffer.limit(MAX_LENGTH * (i + 1));
                    this.fileChannel.read(blockBuffer, (Long)blockOffset.get(i));
                    blockBuffer.position(4 + i * 8);
                }
            }
        }
        return blockOffset;
    }

    public long write(Map<String, String> tagMap, Map<String, String> attributeMap) throws IOException, MetadataException {
        ByteBuffer byteBuffer = this.convertMapToByteBuffer(tagMap, attributeMap);
        return this.write(byteBuffer, -1L);
    }

    public void write(Map<String, String> tagMap, Map<String, String> attributeMap, long position) throws IOException, MetadataException {
        ByteBuffer byteBuffer = this.convertMapToByteBuffer(tagMap, attributeMap);
        this.write(byteBuffer, position);
    }

    private synchronized long write(ByteBuffer byteBuffer, long position) throws IOException {
        if (position < 0L) {
            position = this.fileChannel.size();
        }
        List<Long> blockOffset = this.parseOffsetList(position);
        int blockNumReal = byteBuffer.capacity() / MAX_LENGTH;
        if (blockNumReal < 1) {
            throw new RuntimeException("ByteBuffer capacity is smaller than tagAttributeTotalSize, which is not allowed.");
        }
        if (blockNumReal == 1 && blockOffset.size() == 1) {
            this.fileChannel.write(byteBuffer, blockOffset.get(0));
        } else if (blockOffset.size() >= blockNumReal) {
            int i;
            ByteBuffer byteBufferFinal = ByteBuffer.allocate(blockOffset.size() * MAX_LENGTH);
            byteBufferFinal.putInt(-blockOffset.size());
            for (i = 1; i < blockOffset.size(); ++i) {
                byteBufferFinal.putLong(blockOffset.get(i));
            }
            if (blockNumReal > 1) {
                byteBuffer.position((blockNumReal - 1) * 8 + 4);
            } else {
                byteBuffer.position(0);
            }
            byteBufferFinal.put(byteBuffer);
            for (i = 0; i < blockOffset.size(); ++i) {
                byteBufferFinal.position(i * MAX_LENGTH);
                byteBufferFinal.limit((i + 1) * MAX_LENGTH);
                this.fileChannel.write(byteBufferFinal, blockOffset.get(i));
            }
        } else {
            int i;
            int blockOffsetStoreLen = (blockNumReal - 1) * 8 + 4;
            ByteBuffer byteBufferOffset = ByteBuffer.allocate(blockOffsetStoreLen);
            byteBufferOffset.putInt(-blockNumReal);
            for (i = 0; i < blockNumReal; ++i) {
                byteBuffer.position(i * MAX_LENGTH);
                byteBuffer.limit((i + 1) * MAX_LENGTH);
                if (i < blockOffset.size()) {
                    if (i > 0) {
                        byteBufferOffset.putLong(blockOffset.get(i));
                    }
                    this.fileChannel.write(byteBuffer, blockOffset.get(i));
                    continue;
                }
                byteBufferOffset.putLong(this.fileChannel.size());
                blockOffset.add(this.fileChannel.size());
                this.fileChannel.write(byteBuffer, this.fileChannel.size());
            }
            byteBufferOffset.flip();
            for (i = 0; i < blockOffset.size(); ++i) {
                byteBufferOffset.position(i * MAX_LENGTH);
                if ((i + 1) * MAX_LENGTH > byteBufferOffset.capacity()) {
                    byteBufferOffset.limit(byteBufferOffset.capacity());
                    this.fileChannel.write(byteBufferOffset, blockOffset.get(i));
                    break;
                }
                byteBufferOffset.limit((i + 1) * MAX_LENGTH);
                this.fileChannel.write(byteBufferOffset, blockOffset.get(i));
            }
        }
        ++this.unFlushedRecordNum;
        if (this.unFlushedRecordNum >= RECORD_FLUSH_INTERVAL) {
            this.fileChannel.force(true);
            this.unFlushedRecordNum = 0;
        }
        return position;
    }

    private ByteBuffer convertMapToByteBuffer(Map<String, String> tagMap, Map<String, String> attributeMap) throws MetadataException {
        ByteBuffer byteBuffer;
        int totalMapSize = TagLogFile.calculateMapSize(tagMap) + TagLogFile.calculateMapSize(attributeMap);
        if (totalMapSize <= MAX_LENGTH) {
            byteBuffer = ByteBuffer.allocate(MAX_LENGTH);
        } else {
            double NumMinLimit = (double)(totalMapSize + 4 - MAX_LENGTH) / (double)(MAX_LENGTH - 8);
            int blockNum = (int)Math.ceil(NumMinLimit) + 1;
            byteBuffer = ByteBuffer.allocate(blockNum * MAX_LENGTH);
            byteBuffer.position(4 + (blockNum - 1) * 8);
        }
        this.serializeMap(tagMap, byteBuffer);
        this.serializeMap(attributeMap, byteBuffer);
        byteBuffer.position(0);
        return byteBuffer;
    }

    public static int calculateMapSize(Map<String, String> map) {
        int length = 0;
        if (map != null) {
            length += 4;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                int entryLength = 0;
                String key = entry.getKey();
                String value = entry.getValue();
                entryLength += 4;
                if (key != null) {
                    entryLength += key.getBytes().length;
                }
                entryLength += 4;
                if (value != null) {
                    entryLength += value.getBytes().length;
                }
                length += entryLength;
            }
        } else {
            length += 4;
        }
        return length;
    }

    private void serializeMap(Map<String, String> map, ByteBuffer byteBuffer) throws MetadataException {
        try {
            if (map == null) {
                ReadWriteIOUtils.write((int)0, (ByteBuffer)byteBuffer);
            } else {
                ReadWriteIOUtils.write(map, (ByteBuffer)byteBuffer);
            }
        }
        catch (BufferOverflowException e) {
            throw new MetadataException(LENGTH_EXCEED_MSG);
        }
    }

    @Override
    public void close() throws IOException {
        if (Objects.nonNull(this.fileChannel) && this.fileChannel.isOpen()) {
            this.fileChannel.force(true);
            this.fileChannel.close();
            this.fileChannel = null;
        }
    }
}

