/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker.subscriptions;

import io.moquette.broker.subscriptions.CTrie;
import io.moquette.broker.subscriptions.INode;
import io.moquette.broker.subscriptions.ShareName;
import io.moquette.broker.subscriptions.SharedSubscription;
import io.moquette.broker.subscriptions.Subscription;
import io.moquette.broker.subscriptions.Token;
import io.moquette.broker.subscriptions.Topic;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubscriptionOption;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;

class CNode
implements Comparable<CNode> {
    public static final Random SECURE_RANDOM = new SecureRandom();
    private final Token token;
    private final List<INode> children;
    private List<Subscription> subscriptions;
    private Map<ShareName, List<SharedSubscription>> sharedSubscriptions;

    CNode(Token token) {
        this.children = new ArrayList<INode>();
        this.subscriptions = new ArrayList<Subscription>();
        this.sharedSubscriptions = new HashMap<ShareName, List<SharedSubscription>>();
        this.token = token;
    }

    private CNode(Token token, List<INode> children, List<Subscription> subscriptions, Map<ShareName, List<SharedSubscription>> sharedSubscriptions) {
        this.token = token;
        this.subscriptions = new ArrayList<Subscription>(subscriptions);
        this.sharedSubscriptions = new HashMap<ShareName, List<SharedSubscription>>(sharedSubscriptions);
        this.children = new ArrayList<INode>(children);
    }

    public Token getToken() {
        return this.token;
    }

    List<INode> allChildren() {
        return new ArrayList<INode>(this.children);
    }

    Optional<INode> childOf(Token token) {
        int idx = this.findIndexForToken(token);
        if (idx < 0) {
            return Optional.empty();
        }
        return Optional.of(this.children.get(idx));
    }

    private int findIndexForToken(Token token) {
        INode tempTokenNode = new INode(new CNode(token));
        return Collections.binarySearch(this.children, tempTokenNode, (node, tokenHolder) -> node.mainNode().token.compareTo(tokenHolder.mainNode().token));
    }

    public int hashCode() {
        return Objects.hash(this.token);
    }

    CNode copy() {
        return new CNode(this.token, this.children, this.subscriptions, this.sharedSubscriptions);
    }

    public void add(INode newINode) {
        int idx = this.findIndexForToken(newINode.mainNode().token);
        if (idx < 0) {
            this.children.add(-1 - idx, newINode);
        } else {
            this.children.add(idx, newINode);
        }
    }

    public INode remove(INode node) {
        int idx = this.findIndexForToken(node.mainNode().token);
        return this.children.remove(idx);
    }

    private List<Subscription> sharedSubscriptions() {
        ArrayList<Subscription> selectedSubscriptions = new ArrayList<Subscription>(this.sharedSubscriptions.size());
        for (Map.Entry<ShareName, List<SharedSubscription>> subsForName : this.sharedSubscriptions.entrySet()) {
            List<SharedSubscription> list = subsForName.getValue();
            String shareName = subsForName.getKey().getShareName();
            int randIdx = SECURE_RANDOM.nextInt(list.size());
            SharedSubscription sub = list.get(randIdx);
            selectedSubscriptions.add(sub.createSubscription());
        }
        return selectedSubscriptions;
    }

    List<Subscription> subscriptions() {
        return this.subscriptions;
    }

    CNode addSubscription(CTrie.SubscriptionRequest request) {
        if (request.isShared()) {
            ShareName shareName = request.getSharedName();
            SharedSubscription newSubscription = request.sharedSubscription();
            List subscriptions = this.sharedSubscriptions.getOrDefault(shareName, new ArrayList());
            int idx = Collections.binarySearch(subscriptions, newSubscription);
            if (idx >= 0) {
                subscriptions.set(idx, newSubscription);
            } else {
                subscriptions.add(-1 - idx, newSubscription);
            }
            this.sharedSubscriptions.put(shareName, subscriptions);
        } else {
            Subscription newSubscription = request.subscription();
            int idx = Collections.binarySearch(this.subscriptions, newSubscription);
            if (idx >= 0) {
                Subscription existing = this.subscriptions.get(idx);
                if (CNode.needsToUpdateExistingSubscription(newSubscription, existing)) {
                    this.subscriptions.set(idx, newSubscription);
                }
            } else {
                this.subscriptions.add(-1 - idx, newSubscription);
            }
        }
        return this;
    }

    private static boolean needsToUpdateExistingSubscription(Subscription newSubscription, Subscription existing) {
        if (newSubscription.hasSubscriptionIdentifier() && existing.hasSubscriptionIdentifier() && newSubscription.getSubscriptionIdentifier().equals(existing.getSubscriptionIdentifier())) {
            return existing.option().qos().value() < newSubscription.option().qos().value();
        }
        return true;
    }

    boolean containsOnly(String clientId) {
        for (Subscription sub : this.subscriptions) {
            if (sub.clientId.equals(clientId)) continue;
            return false;
        }
        return !this.subscriptions.isEmpty();
    }

    public boolean contains(String clientId) {
        return this.containsSubscriptionsForClient(clientId) || this.containsSharedSubscriptionsForClient(clientId);
    }

    private boolean containsSharedSubscriptionsForClient(String clientId) {
        boolean result = false;
        for (List<SharedSubscription> sharedForShareName : this.sharedSubscriptions.values()) {
            Comparator<SharedSubscription> compareByClientId;
            SharedSubscription keyWrapper;
            int res = Collections.binarySearch(sharedForShareName, keyWrapper = CNode.wrapKey(clientId), compareByClientId = Comparator.comparing(SharedSubscription::clientId));
            result = res >= 0 || result;
        }
        return result;
    }

    private static SharedSubscription wrapKey(String clientId) {
        MqttQoS unusedQoS = MqttQoS.AT_MOST_ONCE;
        return new SharedSubscription(null, Topic.asTopic("unused"), clientId, MqttSubscriptionOption.onlyFromQos((MqttQoS)unusedQoS));
    }

    private boolean containsSubscriptionsForClient(String clientId) {
        for (Subscription sub : this.subscriptions) {
            if (!sub.clientId.equals(clientId)) continue;
            return true;
        }
        return false;
    }

    void removeSubscriptionsFor(CTrie.UnsubscribeRequest request) {
        String clientId = request.getClientId();
        if (request.isShared()) {
            List<SharedSubscription> subscriptionsForName = this.sharedSubscriptions.get(request.getSharedName());
            List toRemove = subscriptionsForName.stream().filter(sub -> sub.clientId().equals(clientId)).collect(Collectors.toList());
            subscriptionsForName.removeAll(toRemove);
            if (subscriptionsForName.isEmpty()) {
                this.sharedSubscriptions.remove(request.getSharedName());
            } else {
                this.sharedSubscriptions.replace(request.getSharedName(), subscriptionsForName);
            }
        } else {
            HashSet<Subscription> toRemove = new HashSet<Subscription>();
            for (Subscription sub2 : this.subscriptions) {
                if (!sub2.clientId.equals(clientId)) continue;
                toRemove.add(sub2);
            }
            this.subscriptions.removeAll(toRemove);
        }
    }

    @Override
    public int compareTo(CNode o) {
        return this.token.compareTo(o.token);
    }

    public List<Subscription> sharedAndNonSharedSubscriptions() {
        List<Subscription> shared = this.sharedSubscriptions();
        ArrayList<Subscription> returnedSubscriptions = new ArrayList<Subscription>(this.subscriptions.size() + shared.size());
        returnedSubscriptions.addAll(this.subscriptions);
        returnedSubscriptions.addAll(shared);
        return returnedSubscriptions;
    }
}

