/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.james.jdkim.DKIMCommon;
import org.apache.james.jdkim.DKIMSigner;
import org.apache.james.jdkim.DKIMVerifier;
import org.apache.james.jdkim.MockPublicKeyRecordRetriever;
import org.apache.james.jdkim.TestKeys;
import org.apache.james.jdkim.api.Headers;
import org.apache.james.jdkim.api.PublicKeyRecordRetriever;
import org.apache.james.jdkim.api.Result;
import org.apache.james.jdkim.impl.Message;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Assert;
import org.junit.Test;

public class DKIMTest {
    private final MockPublicKeyRecordRetriever keyRecordRetriever = new MockPublicKeyRecordRetriever(MockPublicKeyRecordRetriever.Record.of("selector2", "messiah.edu", "k=rsa; p=" + Base64.encodeBase64String((byte[])TestKeys.publicKey.getEncoded()) + ";"), MockPublicKeyRecordRetriever.Record.of("selector3", "messiah.edu", "k=rsa; p=" + Base64.encodeBase64String((byte[])TestKeys.publicKey_2.getEncoded()) + ";"));
    private static final String SIGNATURE_TEMPLATE = "v=1; a=rsa-sha256; c=simple; d=messiah.edu; h=date:from:subject; q=dns/txt; s=selector2;";
    private static final String SIGNATURE_TEMPLATE_2 = "v=1; a=rsa-sha1; c=simple; d=messiah.edu; h=date:from:subject; q=dns/txt; s=selector2;";
    private static final String SIGNATURE_TEMPLATE_3 = "v=1; a=rsa-sha256; c=simple; d=messiah.edu; h=date:from:subject; q=dns/txt; s=selector3;";
    private final DKIMSigner dkimSigner = new DKIMSigner("v=1; a=rsa-sha256; c=simple; d=messiah.edu; h=date:from:subject; q=dns/txt; s=selector2;", TestKeys.privateKey);
    private final DKIMVerifier verifier = new DKIMVerifier((PublicKeyRecordRetriever)this.keyRecordRetriever);

    @Test
    public void should_verify_generated_signature_single_key() throws Exception {
        String expectedSignature = "DKIM-Signature: a=rsa-sha256; q=dns/txt; b=Axa8s/gTnnJ8em45KV/AQw33hQ4uYtBKiQp3dLq7oRFt+WmDZ5ZErPq4lBVXfP+IAvP+Au91J8270ivn1J/6E0YqKntn4s1hjcNBPPRVohvmlcQ1mEMd6DuYDtWjDFwG2GWZwtilaPY2afhlTuAbHkn8nHm7MVtAGETO8QQ2zfD1NSGzKbNYP9I+hrDJq5ajka6PZn1d+mDhUH5Px8yScYqo5i8Z8GXaejSIu7RsLDuxtOO2cuClRi8MKGxc7MiGndMufXB8xbS1L80IFlyunOVY5eBaqnnhF2YrDDQfZ6DTqorzX6D5dNjpjOG6AbsqkW83Drx0TTV/5M0raU1SIw==; c=simple; s=selector2; d=messiah.edu; v=1; bh=6pQY5V6Dw8mCYWq017gfbpv+x2X4GvOhIIZtKw6iU6g=; h=date:from:subject;";
        ByteArrayInputStream inputStream = this.readFileToByteArrayInputStream("/org/apache/james/jdkim/Mail-DKIM/corpus/multiple_2.txt");
        String actualSignature = this.dkimSigner.sign((InputStream)inputStream);
        Assert.assertEquals((Object)expectedSignature, (Object)actualSignature);
        ByteArrayInputStream originalInputStream = this.readFileToByteArrayInputStream("/org/apache/james/jdkim/Mail-DKIM/corpus/multiple_2.txt");
        ByteArrayInputStream signatureInputStream = new ByteArrayInputStream((actualSignature + "\r\n").getBytes(StandardCharsets.UTF_8));
        SequenceInputStream verifyInputStream = new SequenceInputStream(signatureInputStream, originalInputStream);
        List verifiedSignatures = this.verifier.verify((InputStream)verifyInputStream);
        ((ListAssert)Assertions.assertThat((List)verifiedSignatures).hasSize(1)).allSatisfy(it -> Assertions.assertThat((String)("DKIM-Signature:" + it.toString())).isEqualTo(expectedSignature));
    }

    @Test
    public void should_verify_generated_signature_multiple_keys() throws Exception {
        String expectedSignature = "DKIM-Signature: a=rsa-sha256; q=dns/txt; b=Axa8s/gTnnJ8em45KV/AQw33hQ4uYtBKiQp3dLq7oRFt+WmDZ5ZErPq4lBVXfP+IAvP+Au91J8270ivn1J/6E0YqKntn4s1hjcNBPPRVohvmlcQ1mEMd6DuYDtWjDFwG2GWZwtilaPY2afhlTuAbHkn8nHm7MVtAGETO8QQ2zfD1NSGzKbNYP9I+hrDJq5ajka6PZn1d+mDhUH5Px8yScYqo5i8Z8GXaejSIu7RsLDuxtOO2cuClRi8MKGxc7MiGndMufXB8xbS1L80IFlyunOVY5eBaqnnhF2YrDDQfZ6DTqorzX6D5dNjpjOG6AbsqkW83Drx0TTV/5M0raU1SIw==; c=simple; s=selector2; d=messiah.edu; v=1; bh=6pQY5V6Dw8mCYWq017gfbpv+x2X4GvOhIIZtKw6iU6g=; h=date:from:subject;";
        String expectedSignature2 = "DKIM-Signature: a=rsa-sha1; q=dns/txt; b=YiwcfjqM7myZ/OENExlyGVzy+rg/779R6pF7bPl79aL6e7yGYeN0XdLRcJEqhg+/uNFwcC7zrbWUwPBVFpFN8pKdQT7TgTr+ydoN65QiBa/rXH4m8Ga+oKx8652dXAHm9oMvG166VdMRsEKTJq2bFpM9RR4mW0KtHPte2JWiOtCYO6MPTlWA2JnIgQp+3+03rnOcKdQ+sn/bi9OwanwE4jgIBcPeHkHVr1fVsV53nvDlbk1DiDX+uOXvuk6bjPVBN4srZiSIvFKsmco0tGZx8cgs5OKyjmtIWVOvjxgupXWvEJJ1nMi1UQ1AXh6jDqWrMDCioRCMG9TeGy8fjcjcfw==; c=simple; s=selector2; d=messiah.edu; v=1; bh=q6DWKdHUzNbVPt6YBbD1KOai/b8=; h=date:from:subject;";
        String expectedSignature3 = "DKIM-Signature: a=rsa-sha256; q=dns/txt; b=crkBsqVuTJJmjZyNuJtmGXBsHIT7tJq0ONWLvNfO29sl1kNm9UzTZ4mOYR+akNJqonkaFFaVM9MZ/6QUd5NbGaIytxXnxv+NPNu6ZzUunlcRyOPhEQ/znemg3WjibRs24gWubBZZXApkqQ9kFh/atatoaJhTls/lnbP8ZV3XlWVN12UuESU3qdieRvrhKWX5/Od7LqZS04ZTeToAabOtDmm6hYl2R6wxizdHrOkGiNERfbB8Iaws5f3Qnt0S94wQ5FVTPzgRiO9OW8hYbAijS4Bh8/NXV5xauMXjCETfxX3pQYUuxc4QVhnoMbmuqgEulzuJUzapjotLLFxQRaSsjw==; c=simple; s=selector3; d=messiah.edu; v=1; bh=6pQY5V6Dw8mCYWq017gfbpv+x2X4GvOhIIZtKw6iU6g=; h=date:from:subject;";
        ByteArrayInputStream inputStream1 = this.readFileToByteArrayInputStream("/org/apache/james/jdkim/Mail-DKIM/corpus/multiple_2.txt");
        String actualSignature1 = this.dkimSigner.sign((InputStream)inputStream1);
        ByteArrayInputStream inputStream2 = this.readFileToByteArrayInputStream("/org/apache/james/jdkim/Mail-DKIM/corpus/multiple_2.txt");
        DKIMSigner signer2 = new DKIMSigner(SIGNATURE_TEMPLATE_2, TestKeys.privateKey);
        String actualSignature2 = signer2.sign((InputStream)inputStream2);
        ByteArrayInputStream inputStream3 = this.readFileToByteArrayInputStream("/org/apache/james/jdkim/Mail-DKIM/corpus/multiple_2.txt");
        DKIMSigner signer3 = new DKIMSigner(SIGNATURE_TEMPLATE_3, TestKeys.privateKey_2);
        String actualSignature3 = signer3.sign((InputStream)inputStream3);
        Assert.assertEquals((Object)expectedSignature, (Object)actualSignature1);
        Assert.assertEquals((Object)expectedSignature2, (Object)actualSignature2);
        Assert.assertEquals((Object)expectedSignature3, (Object)actualSignature3);
        ByteArrayInputStream originalInputStream = this.readFileToByteArrayInputStream("/org/apache/james/jdkim/Mail-DKIM/corpus/multiple_2.txt");
        String signatures = String.join((CharSequence)"\r\n", Arrays.asList(actualSignature1, actualSignature2, actualSignature3));
        ByteArrayInputStream signatureInputStream = new ByteArrayInputStream((signatures + "\r\n").getBytes(StandardCharsets.UTF_8));
        SequenceInputStream verifyInputStream = new SequenceInputStream(signatureInputStream, originalInputStream);
        List verifiedSignatures = this.verifier.verify((InputStream)verifyInputStream);
        List results = this.verifier.getResults();
        ((ListAssert)((ListAssert)Assertions.assertThat((List)results).filteredOn(Result::isSuccess)).hasSize(3)).allSatisfy(it -> Assertions.assertThat((CharSequence)it.getRecord().getSelector()).isIn(new Object[]{"selector2", "selector3"}));
        ((ListAssert)((ListAssert)((ListAssert)Assertions.assertThat((List)verifiedSignatures).hasSize(3)).satisfiesOnlyOnce(it -> Assertions.assertThat((String)("DKIM-Signature:" + it.toString())).isEqualTo(expectedSignature))).satisfiesOnlyOnce(it -> Assertions.assertThat((String)("DKIM-Signature:" + it.toString())).isEqualTo(expectedSignature2))).satisfiesOnlyOnce(it -> Assertions.assertThat((String)("DKIM-Signature:" + it.toString())).isEqualTo(expectedSignature3));
    }

    private ByteArrayInputStream readFileToByteArrayInputStream(String fileName) throws URISyntaxException, IOException {
        URL resource = this.getClass().getResource(fileName);
        FileInputStream file = new FileInputStream(new File(resource.toURI()));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DKIMCommon.streamCopy((InputStream)file, (OutputStream)byteArrayOutputStream);
        String string = byteArrayOutputStream.toString();
        return new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
    }

    private static class HeaderSignatureOverride
    implements Headers {
        private final Message headers;
        private final List<String> dkimSignatures;

        public HeaderSignatureOverride(Message headers, List<String> signatures) {
            this.headers = headers;
            this.dkimSignatures = signatures;
        }

        public List<String> getFields() {
            return this.headers.getFields();
        }

        public List<String> getFields(String name) {
            if ("DKIM-Signature".equals(name)) {
                return this.dkimSignatures;
            }
            return this.headers.getFields(name);
        }

        public InputStream getBodyInputStream() {
            return this.headers.getBodyInputStream();
        }
    }
}

