/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mdn.fields;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.mdn.fields.AddressType;
import org.apache.james.mdn.fields.Field;
import org.apache.james.mdn.fields.Text;

public class FinalRecipient
implements Field {
    public static final String FIELD_NAME = "Final-Recipient";
    private final Text finalRecipient;
    private final AddressType addressType;

    public static Builder builder() {
        return new Builder();
    }

    private FinalRecipient(AddressType addressType, Text finalRecipient) {
        this.finalRecipient = finalRecipient;
        this.addressType = addressType;
    }

    public Text getFinalRecipient() {
        return this.finalRecipient;
    }

    public AddressType getAddressType() {
        return this.addressType;
    }

    @Override
    public String formattedValue() {
        return "Final-Recipient: " + this.addressType.getType() + "; " + this.finalRecipient.formatted();
    }

    public final boolean equals(Object o) {
        if (o instanceof FinalRecipient) {
            FinalRecipient that = (FinalRecipient)o;
            return Objects.equals(this.finalRecipient, that.finalRecipient) && Objects.equals(this.addressType, that.addressType);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.finalRecipient, this.addressType);
    }

    public String toString() {
        return this.formattedValue();
    }

    public static class Builder {
        private Optional<AddressType> addressType = Optional.empty();
        private Text finalRecipient;

        private Builder() {
        }

        public Builder addressType(AddressType addressType) {
            this.addressType = Optional.of(addressType);
            return this;
        }

        public Builder finalRecipient(Text finalRecipient) {
            this.finalRecipient = finalRecipient;
            return this;
        }

        public FinalRecipient build() {
            Preconditions.checkNotNull(this.finalRecipient);
            return new FinalRecipient(this.addressType.orElse(AddressType.RFC_822), this.finalRecipient);
        }
    }
}

