/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils;

import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.utils.JavaSystemSetting;
import software.amazon.awssdk.utils.StringUtils;

@SdkProtectedApi
public final class UserHomeDirectoryUtils {
    private UserHomeDirectoryUtils() {
    }

    public static String userHomeDirectory() {
        String home = System.getenv("HOME");
        if (home != null) {
            return home;
        }
        boolean isWindows = JavaSystemSetting.OS_NAME.getStringValue().map(s -> StringUtils.lowerCase(s).startsWith("windows")).orElse(false);
        if (isWindows) {
            String userProfile = System.getenv("USERPROFILE");
            if (userProfile != null) {
                return userProfile;
            }
            String homeDrive = System.getenv("HOMEDRIVE");
            String homePath = System.getenv("HOMEPATH");
            if (homeDrive != null && homePath != null) {
                return homeDrive + homePath;
            }
        }
        return JavaSystemSetting.USER_HOME.getStringValueOrThrow();
    }
}

