/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mu;

import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.core.MailAddress;
import org.apache.james.mu.MailReportEntry;
import org.apache.james.mu.MailReportGenerator;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import reactor.core.publisher.Flux;

public class MuReceivedReportRecorder
extends GenericMailet {
    private final MailReportGenerator mailReportGenerator;
    private final Clock clock;
    private MailReportEntry.Kind kind;

    @Inject
    public MuReceivedReportRecorder(MailReportGenerator mailReportGenerator, Clock clock) {
        this.mailReportGenerator = mailReportGenerator;
        this.clock = clock;
    }

    public void init() throws MessagingException {
        this.kind = (MailReportEntry.Kind)((Object)Optional.ofNullable(this.getInitParameter("kind")).flatMap(MailReportEntry.Kind::parse).orElseThrow(() -> new MessagingException("Unparsable or missing kind property")));
    }

    public void service(Mail mail) throws MessagingException {
        Instant instant = this.clock.instant();
        String subject = Optional.ofNullable(mail.getMessage().getSubject()).orElse("<no subject>");
        Flux.fromIterable((Iterable)mail.getRecipients()).map(recipient -> new MailReportEntry(this.kind, subject, mail.getMaybeSender(), (MailAddress)recipient, instant)).flatMap(this.mailReportGenerator::append, 16).then().block();
    }
}

