/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.NioMessage;
import org.jgroups.Refcountable;
import org.jgroups.annotations.Experimental;
import org.jgroups.util.RefcountImpl;

@Experimental
public class RefcountedNioMessage
extends NioMessage
implements Refcountable<Message> {
    protected final RefcountImpl<Message> impl = new RefcountImpl();

    public RefcountedNioMessage() {
    }

    public RefcountedNioMessage(Address dest) {
        super(dest);
    }

    public RefcountedNioMessage(Address dest, ByteBuffer buf) {
        super(dest, buf);
    }

    public synchronized byte getRefcount() {
        return this.impl.getRefcount();
    }

    @Override
    public synchronized RefcountedNioMessage incr() {
        this.impl.incr();
        return this;
    }

    @Override
    public synchronized RefcountedNioMessage decr() {
        this.impl.decr(this);
        return this;
    }

    public RefcountedNioMessage onRelease(Consumer<Message> rc) {
        this.impl.onRelease(rc);
        return this;
    }

    @Override
    public String toString() {
        return String.format("%s (refcnt=%d)", super.toString(), this.impl.getRefcount());
    }
}

