/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.ContentTypeResolver;
import org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;

public abstract class AbstractMessageConverter
implements SmartMessageConverter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final List<MimeType> supportedMimeTypes;
    private ContentTypeResolver contentTypeResolver = new DefaultContentTypeResolver();
    private boolean strictContentTypeMatch = false;
    private Class<?> serializedPayloadClass = byte[].class;

    protected AbstractMessageConverter(MimeType supportedMimeType) {
        Assert.notNull((Object)supportedMimeType, (String)"supportedMimeType is required");
        this.supportedMimeTypes = Collections.singletonList(supportedMimeType);
    }

    protected AbstractMessageConverter(Collection<MimeType> supportedMimeTypes) {
        Assert.notNull(supportedMimeTypes, (String)"supportedMimeTypes must not be null");
        this.supportedMimeTypes = new ArrayList<MimeType>(supportedMimeTypes);
    }

    public List<MimeType> getSupportedMimeTypes() {
        return Collections.unmodifiableList(this.supportedMimeTypes);
    }

    public void setContentTypeResolver(ContentTypeResolver resolver) {
        this.contentTypeResolver = resolver;
    }

    public ContentTypeResolver getContentTypeResolver() {
        return this.contentTypeResolver;
    }

    public void setStrictContentTypeMatch(boolean strictContentTypeMatch) {
        if (strictContentTypeMatch) {
            Assert.notEmpty(this.getSupportedMimeTypes(), (String)"Strict match requires non-empty list of supported mime types");
            Assert.notNull((Object)this.getContentTypeResolver(), (String)"Strict match requires ContentTypeResolver");
        }
        this.strictContentTypeMatch = strictContentTypeMatch;
    }

    public boolean isStrictContentTypeMatch() {
        return this.strictContentTypeMatch;
    }

    public void setSerializedPayloadClass(Class<?> payloadClass) {
        if (byte[].class != payloadClass && String.class != payloadClass) {
            throw new IllegalArgumentException("Payload class must be byte[] or String: " + payloadClass);
        }
        this.serializedPayloadClass = payloadClass;
    }

    public Class<?> getSerializedPayloadClass() {
        return this.serializedPayloadClass;
    }

    protected MimeType getDefaultContentType(Object payload) {
        List<MimeType> mimeTypes = this.getSupportedMimeTypes();
        return !mimeTypes.isEmpty() ? mimeTypes.get(0) : null;
    }

    @Override
    public final Object fromMessage(Message<?> message, Class<?> targetClass) {
        return this.fromMessage(message, targetClass, null);
    }

    @Override
    public final Object fromMessage(Message<?> message, Class<?> targetClass, Object conversionHint) {
        if (!this.canConvertFrom(message, targetClass)) {
            return null;
        }
        return this.convertFromInternal(message, targetClass, conversionHint);
    }

    protected boolean canConvertFrom(Message<?> message, Class<?> targetClass) {
        return this.supports(targetClass) && this.supportsMimeType(message.getHeaders());
    }

    @Override
    public final Message<?> toMessage(Object payload, MessageHeaders headers) {
        return this.toMessage(payload, headers, null);
    }

    @Override
    public final Message<?> toMessage(Object payload, MessageHeaders headers, Object conversionHint) {
        MessageHeaderAccessor accessor;
        if (!this.canConvertTo(payload, headers)) {
            return null;
        }
        if ((payload = this.convertToInternal(payload, headers, conversionHint)) == null) {
            return null;
        }
        MimeType mimeType = this.getDefaultContentType(payload);
        if (headers != null && (accessor = MessageHeaderAccessor.getAccessor(headers, MessageHeaderAccessor.class)) != null && accessor.isMutable()) {
            accessor.setHeaderIfAbsent("contentType", mimeType);
            return MessageBuilder.createMessage(payload, accessor.getMessageHeaders());
        }
        MessageBuilder<Object> builder = MessageBuilder.withPayload(payload);
        if (headers != null) {
            builder.copyHeaders(headers);
        }
        builder.setHeaderIfAbsent("contentType", mimeType);
        return builder.build();
    }

    protected boolean canConvertTo(Object payload, MessageHeaders headers) {
        Class<?> clazz = payload != null ? payload.getClass() : null;
        return this.supports(clazz) && this.supportsMimeType(headers);
    }

    protected boolean supportsMimeType(MessageHeaders headers) {
        if (this.getSupportedMimeTypes().isEmpty()) {
            return true;
        }
        MimeType mimeType = this.getMimeType(headers);
        if (mimeType == null) {
            return !this.isStrictContentTypeMatch();
        }
        for (MimeType current : this.getSupportedMimeTypes()) {
            if (!current.getType().equals(mimeType.getType()) || !current.getSubtype().equals(mimeType.getSubtype())) continue;
            return true;
        }
        return false;
    }

    protected MimeType getMimeType(MessageHeaders headers) {
        return this.contentTypeResolver != null ? this.contentTypeResolver.resolve(headers) : null;
    }

    protected abstract boolean supports(Class<?> var1);

    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        return this.convertFromInternal(message, targetClass);
    }

    protected Object convertToInternal(Object payload, MessageHeaders headers, Object conversionHint) {
        return this.convertToInternal(payload, headers);
    }

    @Deprecated
    public Object convertFromInternal(Message<?> message, Class<?> targetClass) {
        return null;
    }

    @Deprecated
    public Object convertToInternal(Object payload, MessageHeaders headers) {
        return null;
    }
}

