/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DNEscapingStrategy;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.AttributeBasedLogFieldSyntaxHelper;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogFieldSyntax;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogSyntaxException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogSyntaxMessages;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.RedactedValueException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.TokenizedValueException;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONBuffer;
import java.util.Collection;
import java.util.Set;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DNLogFieldSyntax
extends LogFieldSyntax<DN> {
    @NotNull
    public static final String SYNTAX_NAME = "dn";
    @NotNull
    private static final String REDACTED_DN_STRING = "redacted={REDACTED}";
    private final boolean allAttributesAreSensitive;
    @Nullable
    private final Schema schema;
    @NotNull
    private final Set<String> excludedSensitiveAttributes;
    @NotNull
    private final Set<String> includedSensitiveAttributes;

    public DNLogFieldSyntax(int maxStringLengthCharacters, @Nullable Schema schema, @Nullable Collection<String> includedSensitiveAttributes, @Nullable Collection<String> excludedSensitiveAttributes) {
        super(maxStringLengthCharacters);
        this.schema = schema;
        this.includedSensitiveAttributes = AttributeBasedLogFieldSyntaxHelper.getAttributeSet(schema, includedSensitiveAttributes);
        this.excludedSensitiveAttributes = AttributeBasedLogFieldSyntaxHelper.getAttributeSet(schema, excludedSensitiveAttributes);
        this.allAttributesAreSensitive = this.includedSensitiveAttributes.isEmpty() && this.excludedSensitiveAttributes.isEmpty();
    }

    @NotNull
    public Set<String> getIncludedSensitiveAttributes() {
        return this.includedSensitiveAttributes;
    }

    @NotNull
    public Set<String> getExcludedSensitiveAttributes() {
        return this.excludedSensitiveAttributes;
    }

    @Override
    @NotNull
    public String getSyntaxName() {
        return SYNTAX_NAME;
    }

    @Override
    public void valueToSanitizedString(@NotNull DN value, @NotNull ByteStringBuffer buffer) {
        RDN[] originalRDNs = value.getRDNs();
        RDN[] sanitizedRDNs = new RDN[originalRDNs.length];
        for (int i = 0; i < originalRDNs.length; ++i) {
            String[] attributeNames = originalRDNs[i].getAttributeNames();
            String[] originalValues = originalRDNs[i].getAttributeValues();
            String[] sanitizedValues = new String[originalValues.length];
            for (int j = 0; j < originalValues.length; ++j) {
                sanitizedValues[j] = this.sanitize(originalValues[j]);
            }
            sanitizedRDNs[i] = new RDN(attributeNames, sanitizedValues, this.schema);
        }
        DN sanitizedDN = new DN(sanitizedRDNs);
        sanitizedDN.toString(buffer, DNEscapingStrategy.DEFAULT);
    }

    @Override
    public void logSanitizedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull DN fieldValue, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        this.valueToSanitizedString(fieldValue, buffer);
        buffer.append('\"');
    }

    @Override
    public void logSanitizedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull DN fieldValue, @NotNull JSONBuffer buffer) {
        buffer.appendString(fieldName, this.valueToSanitizedString(fieldValue));
    }

    @Override
    public void logSanitizedValueToJSONFormattedLog(@NotNull DN value, @NotNull JSONBuffer buffer) {
        buffer.appendString(this.valueToSanitizedString(value));
    }

    @Override
    @NotNull
    public DN parseValue(@NotNull String valueString) throws RedactedValueException, TokenizedValueException, LogSyntaxException {
        try {
            return new DN(valueString, this.schema);
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (this.valueStringIsCompletelyRedacted(valueString)) {
                throw new RedactedValueException(LogSyntaxMessages.ERR_DN_LOG_SYNTAX_CANNOT_PARSE_REDACTED.get(), e);
            }
            if (this.valueStringIsCompletelyTokenized(valueString)) {
                throw new TokenizedValueException(LogSyntaxMessages.ERR_DN_LOG_SYNTAX_CANNOT_PARSE_TOKENIZED.get(), e);
            }
            throw new LogSyntaxException(LogSyntaxMessages.ERR_DN_LOG_SYNTAX_CANNOT_PARSE.get(), e);
        }
    }

    @Override
    public boolean valueStringIsCompletelyRedacted(@NotNull String valueString) {
        return valueString.equals("{REDACTED}") || valueString.equals(REDACTED_DN_STRING);
    }

    @Override
    public boolean completelyRedactedValueConformsToSyntax() {
        return true;
    }

    @Override
    public void redactEntireValue(@NotNull ByteStringBuffer buffer) {
        buffer.append(REDACTED_DN_STRING);
    }

    @Override
    public void logCompletelyRedactedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        buffer.append(REDACTED_DN_STRING);
        buffer.append('\"');
    }

    @Override
    public void logCompletelyRedactedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull JSONBuffer buffer) {
        buffer.appendString(fieldName, REDACTED_DN_STRING);
    }

    @Override
    public void logCompletelyRedactedValueToJSONFormattedLog(@NotNull JSONBuffer buffer) {
        buffer.appendString(REDACTED_DN_STRING);
    }

    @Override
    public boolean supportsRedactedComponents() {
        return true;
    }

    @Override
    public boolean valueWithRedactedComponentsConformsToSyntax() {
        return true;
    }

    @Override
    public void redactComponents(@NotNull DN value, @NotNull ByteStringBuffer buffer) {
        RDN[] originalRDNs = value.getRDNs();
        RDN[] redactedRDNs = new RDN[originalRDNs.length];
        for (int i = 0; i < originalRDNs.length; ++i) {
            RDN rdn = originalRDNs[i];
            String[] attributeNames = rdn.getAttributeNames();
            String[] originalValues = rdn.getAttributeValues();
            String[] redactedValues = rdn.getAttributeValues();
            for (int j = 0; j < attributeNames.length; ++j) {
                redactedValues[j] = this.shouldRedactOrTokenize(attributeNames[j]) ? "{REDACTED}" : this.sanitize(originalValues[j]);
            }
            redactedRDNs[i] = new RDN(attributeNames, redactedValues, this.schema);
        }
        DN redactedDN = new DN(redactedRDNs);
        redactedDN.toString(buffer, DNEscapingStrategy.DEFAULT);
    }

    private boolean shouldRedactOrTokenize(@NotNull String attributeName) {
        if (this.allAttributesAreSensitive) {
            return true;
        }
        String lowerName = StaticUtils.toLowerCase(attributeName);
        if (this.includedSensitiveAttributes.contains(lowerName)) {
            return true;
        }
        if (this.excludedSensitiveAttributes.isEmpty()) {
            return false;
        }
        return !this.excludedSensitiveAttributes.contains(lowerName);
    }

    @Override
    public void logRedactedComponentsFieldToTextFormattedLog(@NotNull String fieldName, @NotNull DN fieldValue, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        this.redactComponents(fieldValue, buffer);
        buffer.append('\"');
    }

    @Override
    public void logRedactedComponentsFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull DN fieldValue, @NotNull JSONBuffer buffer) {
        buffer.appendString(fieldName, this.redactComponents(fieldValue));
    }

    @Override
    public void logRedactedComponentsValueToJSONFormattedLog(@NotNull DN value, @NotNull JSONBuffer buffer) {
        buffer.appendString(this.redactComponents(value));
    }

    @Override
    public boolean valueStringIsCompletelyTokenized(@NotNull String valueString) {
        return super.valueStringIsCompletelyTokenized(valueString) || valueString.startsWith("tokenized={TOKENIZED:") && valueString.endsWith("}");
    }

    @Override
    public boolean completelyTokenizedValueConformsToSyntax() {
        return true;
    }

    @Override
    public void tokenizeEntireValue(@NotNull DN value, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        buffer.append("tokenized=");
        this.tokenize(value.toNormalizedString(), pepper, buffer);
    }

    @Override
    public void logCompletelyTokenizedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull DN fieldValue, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        this.tokenizeEntireValue(fieldValue, pepper, buffer);
        buffer.append('\"');
    }

    @Override
    public void logCompletelyTokenizedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull DN fieldValue, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendString(fieldName, this.tokenizeEntireValue(fieldValue, pepper));
    }

    @Override
    public void logCompletelyTokenizedValueToJSONFormattedLog(@NotNull DN value, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendString(this.tokenizeEntireValue(value, pepper));
    }

    @Override
    public boolean supportsTokenizedComponents() {
        return true;
    }

    @Override
    public boolean valueWithTokenizedComponentsConformsToSyntax() {
        return true;
    }

    @Override
    public void tokenizeComponents(@NotNull DN value, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        RDN[] originalRDNs = value.getRDNs();
        RDN[] tokenizedRDNs = new RDN[originalRDNs.length];
        for (int i = 0; i < originalRDNs.length; ++i) {
            RDN rdn = originalRDNs[i];
            String[] attributeNames = rdn.getAttributeNames();
            String[] tokenizedValues = new String[attributeNames.length];
            for (int j = 0; j < attributeNames.length; ++j) {
                tokenizedValues[j] = this.shouldRedactOrTokenize(attributeNames[j]) ? AttributeBasedLogFieldSyntaxHelper.tokenizeValue(this, this.schema, attributeNames[j], rdn.getByteArrayAttributeValues()[j], pepper) : this.sanitize(rdn.getAttributeValues()[j]);
            }
            tokenizedRDNs[i] = new RDN(attributeNames, tokenizedValues, this.schema);
        }
        DN tokenizedDN = new DN(tokenizedRDNs);
        tokenizedDN.toString(buffer, DNEscapingStrategy.DEFAULT);
    }

    @Override
    public void logTokenizedComponentsFieldToTextFormattedLog(@NotNull String fieldName, @NotNull DN fieldValue, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        this.tokenizeComponents(fieldValue, pepper, buffer);
        buffer.append('\"');
    }

    @Override
    public void logTokenizedComponentsFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull DN fieldValue, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendString(fieldName, this.tokenizeComponents(fieldValue, pepper));
    }

    @Override
    public void logTokenizedComponentsValueToJSONFormattedLog(@NotNull DN value, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendString(this.tokenizeComponents(value, pepper));
    }
}

