/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.function.Supplier;
import org.apache.juneau.http.Constants;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.header.BasicStringRangeArrayHeader;
import org.apache.juneau.internal.Cache;

@Header(value="Accept-Language")
public class AcceptLanguage
extends BasicStringRangeArrayHeader {
    private static final long serialVersionUID = 1L;
    private static final Cache<String, AcceptLanguage> CACHE = new Cache(Constants.NOCACHE, Constants.CACHE_MAX_SIZE);

    public static AcceptLanguage of(String value) {
        if (value == null) {
            return null;
        }
        AcceptLanguage x = CACHE.get(value);
        if (x == null) {
            x = CACHE.put(value, new AcceptLanguage(value));
        }
        return x;
    }

    public static AcceptLanguage of(Object value) {
        return new AcceptLanguage(value);
    }

    public static AcceptLanguage of(Supplier<?> value) {
        return new AcceptLanguage(value);
    }

    public AcceptLanguage(Object value) {
        super("Accept-Language", value);
    }

    public AcceptLanguage(String value) {
        this((Object)value);
    }
}

