/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.swagger;

import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.bean.swagger.Items;
import org.apache.juneau.bean.swagger.SchemaInfo;
import org.apache.juneau.bean.swagger.Swagger;
import org.apache.juneau.bean.swagger.SwaggerElement;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.marshaller.Json5;

public class ParameterInfo
extends SwaggerElement {
    private static final String[] VALID_IN = new String[]{"query", "header", "path", "formData", "body"};
    private static final String[] VALID_TYPES = new String[]{"string", "number", "integer", "boolean", "array", "file"};
    private static final String[] VALID_COLLECTION_FORMATS = new String[]{"csv", "ssv", "tsv", "pipes", "multi"};
    private String name;
    private String in;
    private String description;
    private String type;
    private String format;
    private String pattern;
    private String collectionFormat;
    private Number maximum;
    private Number minimum;
    private Number multipleOf;
    private Integer maxLength;
    private Integer minLength;
    private Integer maxItems;
    private Integer minItems;
    private Boolean required;
    private Boolean allowEmptyValue;
    private Boolean exclusiveMaximum;
    private Boolean exclusiveMinimum;
    private Boolean uniqueItems;
    private SchemaInfo schema;
    private Items items;
    private Object default_;
    private Set<Object> enum_ = new LinkedHashSet<Object>();
    private Object example;
    private Map<String, String> examples;

    public ParameterInfo() {
    }

    public ParameterInfo(ParameterInfo copyFrom) {
        super(copyFrom);
        this.allowEmptyValue = copyFrom.allowEmptyValue;
        this.collectionFormat = copyFrom.collectionFormat;
        this.default_ = copyFrom.default_;
        this.description = copyFrom.description;
        if (Utils.nn(copyFrom.enum_)) {
            this.enum_.addAll(CollectionUtils.copyOf(copyFrom.enum_));
        }
        this.example = copyFrom.example;
        this.exclusiveMaximum = copyFrom.exclusiveMaximum;
        this.exclusiveMinimum = copyFrom.exclusiveMinimum;
        this.format = copyFrom.format;
        this.in = copyFrom.in;
        this.items = copyFrom.items == null ? null : copyFrom.items.copy();
        this.maximum = copyFrom.maximum;
        this.maxItems = copyFrom.maxItems;
        this.maxLength = copyFrom.maxLength;
        this.minimum = copyFrom.minimum;
        this.minItems = copyFrom.minItems;
        this.minLength = copyFrom.minLength;
        this.multipleOf = copyFrom.multipleOf;
        this.name = copyFrom.name;
        this.pattern = copyFrom.pattern;
        this.required = copyFrom.required;
        this.schema = copyFrom.schema == null ? null : copyFrom.schema.copy();
        this.type = copyFrom.type;
        this.uniqueItems = copyFrom.uniqueItems;
        this.examples = CollectionUtils.copyOf(copyFrom.examples);
    }

    public ParameterInfo addEnum(Object ... value) {
        if (Utils.nn((Object)value)) {
            for (Object v : value) {
                if (!Utils.nn((Object)v)) continue;
                this.enum_.add(v);
            }
        }
        return this;
    }

    public ParameterInfo copy() {
        return new ParameterInfo(this);
    }

    public ParameterInfo copyFrom(ParameterInfo p) {
        if (Utils.nn((Object)p)) {
            if (Utils.nn((Object)p.name)) {
                this.name = p.name;
            }
            if (Utils.nn((Object)p.in)) {
                this.in = p.in;
            }
            if (Utils.nn((Object)p.description)) {
                this.description = p.description;
            }
            if (Utils.nn((Object)p.type)) {
                this.type = p.type;
            }
            if (Utils.nn((Object)p.format)) {
                this.format = p.format;
            }
            if (Utils.nn((Object)p.pattern)) {
                this.pattern = p.pattern;
            }
            if (Utils.nn((Object)p.collectionFormat)) {
                this.collectionFormat = p.collectionFormat;
            }
            if (Utils.nn((Object)p.maximum)) {
                this.maximum = p.maximum;
            }
            if (Utils.nn((Object)p.minimum)) {
                this.minimum = p.minimum;
            }
            if (Utils.nn((Object)p.multipleOf)) {
                this.multipleOf = p.multipleOf;
            }
            if (Utils.nn((Object)p.maxLength)) {
                this.maxLength = p.maxLength;
            }
            if (Utils.nn((Object)p.minLength)) {
                this.minLength = p.minLength;
            }
            if (Utils.nn((Object)p.maxItems)) {
                this.maxItems = p.maxItems;
            }
            if (Utils.nn((Object)p.minItems)) {
                this.minItems = p.minItems;
            }
            if (Utils.nn((Object)p.required)) {
                this.required = p.required;
            }
            if (Utils.nn((Object)p.allowEmptyValue)) {
                this.allowEmptyValue = p.allowEmptyValue;
            }
            if (Utils.nn((Object)p.exclusiveMaximum)) {
                this.exclusiveMaximum = p.exclusiveMaximum;
            }
            if (Utils.nn((Object)p.exclusiveMinimum)) {
                this.exclusiveMinimum = p.exclusiveMinimum;
            }
            if (Utils.nn((Object)p.uniqueItems)) {
                this.uniqueItems = p.uniqueItems;
            }
            if (Utils.nn((Object)p.schema)) {
                this.schema = p.schema;
            }
            if (Utils.nn((Object)p.items)) {
                this.items = p.items;
            }
            if (Utils.nn((Object)p.default_)) {
                this.default_ = p.default_;
            }
            if (Utils.nn(p.enum_)) {
                this.enum_ = p.enum_;
            }
            if (Utils.nn((Object)p.example)) {
                this.example = p.example;
            }
            if (Utils.nn(p.examples)) {
                this.examples = p.examples;
            }
        }
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return (T)(switch (property) {
            case "allowEmptyValue" -> ConverterUtils.toType((Object)this.getAllowEmptyValue(), type);
            case "collectionFormat" -> ConverterUtils.toType((Object)this.getCollectionFormat(), type);
            case "default" -> ConverterUtils.toType((Object)this.getDefault(), type);
            case "description" -> ConverterUtils.toType((Object)this.getDescription(), type);
            case "enum" -> ConverterUtils.toType(this.getEnum(), type);
            case "example" -> ConverterUtils.toType((Object)this.getExample(), type);
            case "examples" -> ConverterUtils.toType(this.getExamples(), type);
            case "exclusiveMaximum" -> ConverterUtils.toType((Object)this.getExclusiveMaximum(), type);
            case "exclusiveMinimum" -> ConverterUtils.toType((Object)this.getExclusiveMinimum(), type);
            case "format" -> ConverterUtils.toType((Object)this.getFormat(), type);
            case "in" -> ConverterUtils.toType((Object)this.getIn(), type);
            case "items" -> ConverterUtils.toType((Object)this.getItems(), type);
            case "maximum" -> ConverterUtils.toType((Object)this.getMaximum(), type);
            case "maxItems" -> ConverterUtils.toType((Object)this.getMaxItems(), type);
            case "maxLength" -> ConverterUtils.toType((Object)this.getMaxLength(), type);
            case "minimum" -> ConverterUtils.toType((Object)this.getMinimum(), type);
            case "minItems" -> ConverterUtils.toType((Object)this.getMinItems(), type);
            case "minLength" -> ConverterUtils.toType((Object)this.getMinLength(), type);
            case "multipleOf" -> ConverterUtils.toType((Object)this.getMultipleOf(), type);
            case "name" -> ConverterUtils.toType((Object)this.getName(), type);
            case "pattern" -> ConverterUtils.toType((Object)this.getPattern(), type);
            case "required" -> ConverterUtils.toType((Object)this.getRequired(), type);
            case "schema" -> ConverterUtils.toType((Object)this.getSchema(), type);
            case "type" -> ConverterUtils.toType((Object)this.getType(), type);
            case "uniqueItems" -> ConverterUtils.toType((Object)this.getUniqueItems(), type);
            default -> super.get(property, type);
        });
    }

    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public String getCollectionFormat() {
        return this.collectionFormat;
    }

    public Object getDefault() {
        return this.default_;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<Object> getEnum() {
        return Utils.nullIfEmpty(this.enum_);
    }

    public Object getExample() {
        return this.example;
    }

    public Map<String, String> getExamples() {
        return this.examples;
    }

    public Boolean getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public Boolean getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public String getFormat() {
        return this.format;
    }

    public String getIn() {
        return this.in;
    }

    public Items getItems() {
        return this.items;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public String getName() {
        return this.name;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public SchemaInfo getSchema() {
        return this.schema;
    }

    public String getType() {
        return this.type;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setb(String.class).addIf(Utils.nn((Object)this.allowEmptyValue), (Object)"allowEmptyValue").addIf(Utils.nn((Object)this.collectionFormat), (Object)"collectionFormat").addIf(Utils.nn((Object)this.default_), (Object)"default").addIf(Utils.nn((Object)this.description), (Object)"description").addIf(Utils.ne(this.enum_), (Object)"enum").addIf(Utils.nn((Object)this.example), (Object)"example").addIf(Utils.nn(this.examples), (Object)"examples").addIf(Utils.nn((Object)this.exclusiveMaximum), (Object)"exclusiveMaximum").addIf(Utils.nn((Object)this.exclusiveMinimum), (Object)"exclusiveMinimum").addIf(Utils.nn((Object)this.format), (Object)"format").addIf(Utils.nn((Object)this.in), (Object)"in").addIf(Utils.nn((Object)this.items), (Object)"items").addIf(Utils.nn((Object)this.maxItems), (Object)"maxItems").addIf(Utils.nn((Object)this.maxLength), (Object)"maxLength").addIf(Utils.nn((Object)this.maximum), (Object)"maximum").addIf(Utils.nn((Object)this.minItems), (Object)"minItems").addIf(Utils.nn((Object)this.minLength), (Object)"minLength").addIf(Utils.nn((Object)this.minimum), (Object)"minimum").addIf(Utils.nn((Object)this.multipleOf), (Object)"multipleOf").addIf(Utils.nn((Object)this.name), (Object)"name").addIf(Utils.nn((Object)this.pattern), (Object)"pattern").addIf(Utils.nn((Object)this.required), (Object)"required").addIf(Utils.nn((Object)this.schema), (Object)"schema").addIf(Utils.nn((Object)this.type), (Object)"type").addIf(Utils.nn((Object)this.uniqueItems), (Object)"uniqueItems").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }

    public ParameterInfo resolveRefs(Swagger swagger, Deque<String> refStack, int maxDepth) {
        if (Utils.nn((Object)this.schema)) {
            this.schema = this.schema.resolveRefs(swagger, refStack, maxDepth);
        }
        if (Utils.nn((Object)this.items)) {
            this.items = this.items.resolveRefs(swagger, refStack, maxDepth);
        }
        return this;
    }

    @Override
    public ParameterInfo set(String property, Object value) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return switch (property) {
            case "allowEmptyValue" -> this.setAllowEmptyValue(ConverterUtils.toBoolean((Object)value));
            case "collectionFormat" -> this.setCollectionFormat(Utils.s((Object)value));
            case "default" -> this.setDefault(value);
            case "description" -> this.setDescription(Utils.s((Object)value));
            case "enum" -> this.setEnum(value);
            case "example" -> this.setExample(value);
            case "examples" -> this.setExamples((Map)ConverterUtils.toType((Object)value, Map.class));
            case "exclusiveMaximum" -> this.setExclusiveMaximum(ConverterUtils.toBoolean((Object)value));
            case "exclusiveMinimum" -> this.setExclusiveMinimum(ConverterUtils.toBoolean((Object)value));
            case "format" -> this.setFormat(Utils.s((Object)value));
            case "in" -> this.setIn(Utils.s((Object)value));
            case "items" -> this.setItems((Items)ConverterUtils.toType((Object)value, Items.class));
            case "maximum" -> this.setMaximum(ConverterUtils.toNumber((Object)value));
            case "maxItems" -> this.setMaxItems(ConverterUtils.toInteger((Object)value));
            case "maxLength" -> this.setMaxLength(ConverterUtils.toInteger((Object)value));
            case "minimum" -> this.setMinimum(ConverterUtils.toNumber((Object)value));
            case "minItems" -> this.setMinItems(ConverterUtils.toInteger((Object)value));
            case "minLength" -> this.setMinLength(ConverterUtils.toInteger((Object)value));
            case "multipleOf" -> this.setMultipleOf(ConverterUtils.toNumber((Object)value));
            case "name" -> this.setName(Utils.s((Object)value));
            case "pattern" -> this.setPattern(Utils.s((Object)value));
            case "required" -> this.setRequired(ConverterUtils.toBoolean((Object)value));
            case "schema" -> this.setSchema((SchemaInfo)ConverterUtils.toType((Object)value, SchemaInfo.class));
            case "type" -> this.setType(Utils.s((Object)value));
            case "uniqueItems" -> this.setUniqueItems(ConverterUtils.toBoolean((Object)value));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public ParameterInfo setAllowEmptyValue(Boolean value) {
        this.allowEmptyValue = value;
        return this;
    }

    public ParameterInfo setCollectionFormat(String value) {
        if (this.isStrict() && !CollectionUtils.contains((Object)value, (Object[])VALID_COLLECTION_FORMATS)) {
            throw ThrowableUtils.rex((String)"Invalid value passed in to setCollectionFormat(String).  Value=''{0}'', valid values={1}", (Object[])new Object[]{value, Json5.of((Object)VALID_COLLECTION_FORMATS)});
        }
        this.collectionFormat = value;
        return this;
    }

    public ParameterInfo setDefault(Object value) {
        this.default_ = value;
        return this;
    }

    public ParameterInfo setDescription(String value) {
        this.description = value;
        return this;
    }

    public ParameterInfo setEnum(Collection<Object> value) {
        this.enum_.clear();
        if (Utils.nn(value)) {
            this.enum_.addAll(value);
        }
        return this;
    }

    public ParameterInfo setEnum(Object ... value) {
        this.setEnum(CollectionUtils.setb(Object.class).sparse().addAny(value).build());
        return this;
    }

    public ParameterInfo setExample(Object value) {
        this.example = value;
        return this;
    }

    public ParameterInfo setExamples(Map<String, String> value) {
        this.examples = value;
        return this;
    }

    public ParameterInfo setExclusiveMaximum(Boolean value) {
        this.exclusiveMaximum = value;
        return this;
    }

    public ParameterInfo setExclusiveMinimum(Boolean value) {
        this.exclusiveMinimum = value;
        return this;
    }

    public ParameterInfo setFormat(String value) {
        this.format = value;
        return this;
    }

    public ParameterInfo setIn(String value) {
        if (this.isStrict() && !CollectionUtils.contains((Object)value, (Object[])VALID_IN)) {
            throw ThrowableUtils.rex((String)"Invalid value passed in to setIn(String).  Value=''{0}'', valid values={1}", (Object[])new Object[]{value, Json5.of((Object)VALID_IN)});
        }
        this.in = value;
        if ("path".equals(value)) {
            this.required = true;
        }
        return this;
    }

    public ParameterInfo setItems(Items value) {
        this.items = value;
        return this;
    }

    public ParameterInfo setMaximum(Number value) {
        this.maximum = value;
        return this;
    }

    public ParameterInfo setMaxItems(Integer value) {
        this.maxItems = value;
        return this;
    }

    public ParameterInfo setMaxLength(Integer value) {
        this.maxLength = value;
        return this;
    }

    public ParameterInfo setMinimum(Number value) {
        this.minimum = value;
        return this;
    }

    public ParameterInfo setMinItems(Integer value) {
        this.minItems = value;
        return this;
    }

    public ParameterInfo setMinLength(Integer value) {
        this.minLength = value;
        return this;
    }

    public ParameterInfo setMultipleOf(Number value) {
        this.multipleOf = value;
        return this;
    }

    public ParameterInfo setName(String value) {
        if (!"body".equals(this.in)) {
            this.name = value;
        }
        return this;
    }

    public ParameterInfo setPattern(String value) {
        this.pattern = value;
        return this;
    }

    public ParameterInfo setRequired(Boolean value) {
        this.required = value;
        return this;
    }

    public ParameterInfo setSchema(SchemaInfo value) {
        this.schema = value;
        return this;
    }

    public ParameterInfo setType(String value) {
        if (this.isStrict() && !CollectionUtils.contains((Object)value, (Object[])VALID_TYPES)) {
            throw ThrowableUtils.rex((String)"Invalid value passed in to setType(String).  Value=''{0}'', valid values={1}", (Object[])new Object[]{value, Json5.of((Object)VALID_TYPES)});
        }
        this.type = value;
        return this;
    }

    public ParameterInfo setUniqueItems(Boolean value) {
        this.uniqueItems = value;
        return this;
    }

    @Override
    public ParameterInfo strict() {
        super.strict();
        return this;
    }

    @Override
    public ParameterInfo strict(Object value) {
        super.strict(value);
        return this;
    }
}

