/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.jaas.modules.JaasHelper;
import org.apache.karaf.shell.ssh.KarafJaasAuthenticator;
import org.apache.karaf.shell.util.ShellUtil;
import org.apache.karaf.util.StreamLoggerInterceptor;
import org.apache.karaf.util.StreamUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellCommand
implements Command,
Runnable,
SessionAware {
    public static final String SHELL_INIT_SCRIPT = "karaf.shell.init.script";
    public static final String EXEC_INIT_SCRIPT = "karaf.exec.init.script";
    private static final Logger LOGGER = LoggerFactory.getLogger(ShellCommand.class);
    private static final Class[] SECURITY_BUGFIX = new Class[]{JaasHelper.class, JaasHelper.OsgiSubjectDomainCombiner.class, JaasHelper.DelegatingProtectionDomain.class};
    private String command;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private ExitCallback callback;
    private ServerSession session;
    private CommandProcessor commandProcessor;
    private Environment env;
    private boolean consoleLogger = false;
    private String consoleLoggerName;
    private String consoleLoggerOutLevel;
    private String consoleLoggerErrLevel;

    public ShellCommand(CommandProcessor commandProcessor, String command, boolean consoleLogger, String consoleLoggerName, String consoleLoggerOutLevel, String consoleLoggerErrLevel) {
        this.commandProcessor = commandProcessor;
        this.command = command;
        this.consoleLogger = consoleLogger;
        this.consoleLoggerName = consoleLoggerName;
        this.consoleLoggerOutLevel = consoleLoggerOutLevel;
        this.consoleLoggerErrLevel = consoleLoggerErrLevel;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = this.consoleLogger ? new StreamLoggerInterceptor(out, this.consoleLoggerName, this.consoleLoggerOutLevel) : out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = this.consoleLogger ? new StreamLoggerInterceptor(err, this.consoleLoggerName, this.consoleLoggerErrLevel) : err;
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public void setSession(ServerSession session) {
        this.session = session;
    }

    public void start(Environment env) throws IOException {
        this.env = env;
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int exitStatus = 0;
        final CommandSession commandSession = this.commandProcessor.createSession(this.in, new PrintStream(this.out), new PrintStream(this.err));
        try {
            commandSession.put("SCOPE", (Object)"shell:osgi:*");
            commandSession.put("APPLICATION", (Object)System.getProperty("karaf.name", "root"));
            for (Map.Entry e : this.env.getEnv().entrySet()) {
                commandSession.put((String)e.getKey(), e.getValue());
            }
            try {
                Object result;
                Subject subject;
                Subject subject2 = subject = this.session != null ? (Subject)this.session.getAttribute(KarafJaasAuthenticator.SUBJECT_ATTRIBUTE_KEY) : null;
                if (subject != null) {
                    try {
                        result = JaasHelper.doAs((Subject)subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                String scriptFileName = System.getProperty(ShellCommand.EXEC_INIT_SCRIPT);
                                if (scriptFileName == null) {
                                    scriptFileName = System.getProperty(ShellCommand.SHELL_INIT_SCRIPT);
                                }
                                ShellCommand.this.executeScript(scriptFileName, commandSession);
                                return commandSession.execute((CharSequence)ShellCommand.this.command);
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        throw e.getException();
                    }
                } else {
                    String scriptFileName = System.getProperty(EXEC_INIT_SCRIPT);
                    if (scriptFileName == null) {
                        scriptFileName = System.getProperty(SHELL_INIT_SCRIPT);
                    }
                    this.executeScript(scriptFileName, commandSession);
                    result = commandSession.execute((CharSequence)this.command);
                }
                if (result != null) {
                    commandSession.getConsole().println(commandSession.format(result, 0));
                }
            }
            catch (Throwable t) {
                exitStatus = 1;
                ShellUtil.logException((CommandSession)commandSession, (Throwable)t);
            }
        }
        catch (Exception e) {
            try {
                exitStatus = 1;
                LOGGER.error("Unable to start shell", (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtils.close(this.in, this.out, this.err);
                commandSession.close();
                this.callback.onExit(exitStatus);
                throw throwable;
            }
            StreamUtils.close(this.in, this.out, this.err);
            commandSession.close();
            this.callback.onExit(exitStatus);
        }
        StreamUtils.close(this.in, this.out, this.err);
        commandSession.close();
        this.callback.onExit(exitStatus);
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScript(String scriptFileName, CommandSession session) {
        if (scriptFileName != null) {
            Reader r = null;
            try {
                int n;
                File scriptFile = new File(scriptFileName);
                r = new InputStreamReader(new FileInputStream(scriptFile));
                CharArrayWriter w = new CharArrayWriter();
                char[] buf = new char[8192];
                while ((n = r.read(buf)) > 0) {
                    w.write(buf, 0, n);
                }
                session.execute((CharSequence)new String(w.toCharArray()));
            }
            catch (Exception e) {
                LOGGER.debug("Error in initialization script", (Throwable)e);
            }
            finally {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }
}

