/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.util;

import java.io.OutputStream;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamLoggerInterceptor
extends PrintStream {
    private Logger logger;
    private String logLevel;

    public StreamLoggerInterceptor(OutputStream stream, String loggerName, String logLevel) {
        super(stream, true);
        this.logger = LoggerFactory.getLogger((String)loggerName);
        this.logLevel = logLevel;
    }

    @Override
    public void print(String s) {
        this.log(s);
        super.print(s);
    }

    @Override
    public void println(String s) {
        this.log(s);
        super.println(s);
    }

    private void log(String s) {
        if (this.logLevel.equalsIgnoreCase("debug")) {
            this.logger.debug(s);
        } else if (this.logLevel.equalsIgnoreCase("error")) {
            this.logger.error(s);
        } else if (this.logLevel.equalsIgnoreCase("fatal")) {
            this.logger.error(s);
        } else if (this.logLevel.equalsIgnoreCase("info")) {
            this.logger.info(s);
        } else if (this.logLevel.equalsIgnoreCase("trace")) {
            this.logger.trace(s);
        } else if (this.logLevel.equalsIgnoreCase("warn")) {
            this.logger.warn(s);
        }
    }
}

