/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.shared;

import java.io.Serializable;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.SchemaManager;

class SortedEntryComparator
implements Comparator<Entry>,
Serializable {
    private transient AttributeType type;
    private transient LdapComparator comparator;
    private boolean multivalued;
    private boolean reverse;
    private boolean hr;

    SortedEntryComparator(AttributeType at, String mrule, boolean reverse, SchemaManager schemaManager) throws LdapException {
        this.type = at;
        this.reverse = reverse;
        if (!at.isSingleValued()) {
            this.multivalued = true;
        }
        this.hr = at.getSyntax().isHumanReadable();
        if (mrule != null) {
            this.comparator = schemaManager.lookupComparatorRegistry(mrule);
        } else {
            MatchingRule mr = at.getOrdering();
            if (mr == null) {
                mr = at.getEquality();
            }
            this.comparator = schemaManager.lookupComparatorRegistry(mr.getOid());
        }
        this.comparator.setSchemaManager(schemaManager);
    }

    @Override
    public int compare(Entry entry1, Entry entry2) {
        Attribute at1 = entry1.get(this.type);
        Attribute at2 = entry2.get(this.type);
        if (at1 == null) {
            return this.reverse ? -1 : 1;
        }
        if (at2 == null) {
            return this.reverse ? 1 : -1;
        }
        Object o1 = null;
        Object o2 = null;
        if (this.multivalued) {
            TreeSet ts = new TreeSet(this.comparator);
            o1 = this.sortAndGetFirst(at1, ts);
            ts.clear();
            o2 = this.sortAndGetFirst(at2, ts);
        } else {
            Value<?> v1 = at1.get();
            Value<?> v2 = at2.get();
            if (this.hr) {
                o1 = v1.getString();
                o2 = v2.getString();
            } else {
                o1 = v1.getBytes();
                o2 = v2.getBytes();
            }
        }
        int c = 1;
        c = this.reverse ? this.comparator.compare(o2, o1) : this.comparator.compare(o1, o2);
        if (c == 0) {
            return 1;
        }
        return c;
    }

    private Object sortAndGetFirst(Attribute at, TreeSet ts) {
        for (Value v : at) {
            if (this.hr) {
                ts.add(v.getString());
                continue;
            }
            ts.add(v.getBytes());
        }
        return ts.first();
    }
}

