/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.livy;

import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class LivyServiceModelGenerator
extends AbstractServiceModelGenerator {
    private static final String SERVICE = "LIVYSERVER";
    private static final String SERVICE_TYPE = "LIVY";
    private static final String ROLE_TYPE = "LIVY_SERVER";

    @Override
    public boolean handles(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        return SERVICE_TYPE.equals(service.getType()) && ROLE_TYPE.equals(role.getType());
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        String hostname = role.getHostRef().getHostname();
        String port = this.getRoleConfigValue(roleConfig, "livy_server_port");
        boolean sslEnabled = Boolean.parseBoolean(this.getRoleConfigValue(roleConfig, "ssl_enabled"));
        String scheme = sslEnabled ? "https" : "http";
        return new ServiceModel(ServiceModel.Type.API, SERVICE, String.format(Locale.getDefault(), "%s://%s:%s", scheme, hostname, port));
    }
}

