/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.hue;

import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class HueServiceModelGenerator
extends AbstractServiceModelGenerator {
    public static final String SERVICE = "HUE";
    public static final String SERVICE_TYPE = "HUE";
    public static final String ROLE_TYPE = "HUE_SERVER";
    static final String HUE_HTTP_PORT = "hue_http_port";
    static final String SSL_ENABLED = "ssl_enable";

    @Override
    public String getService() {
        return "HUE";
    }

    @Override
    public String getServiceType() {
        return "HUE";
    }

    @Override
    public String getRoleType() {
        return ROLE_TYPE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.UI;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        String hostname = role.getHostRef().getHostname();
        String port = this.getRoleConfigValue(roleConfig, HUE_HTTP_PORT);
        boolean sslEnabled = Boolean.parseBoolean(this.getRoleConfigValue(roleConfig, SSL_ENABLED));
        String scheme = sslEnabled ? "https" : "http";
        ServiceModel model = this.createServiceModel(String.format(Locale.getDefault(), "%s://%s:%s", scheme, hostname, port));
        model.addRoleProperty(this.getRoleType(), HUE_HTTP_PORT, port);
        model.addRoleProperty(this.getRoleType(), SSL_ENABLED, this.getRoleConfigValue(roleConfig, SSL_ENABLED));
        return model;
    }
}

