/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.client;

import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.JettyClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.vault.client.ClientHttpRequestFactoryFactory;
import org.springframework.vault.support.ClientOptions;
import org.springframework.vault.support.SslConfiguration;
import reactor.netty.http.client.HttpClient;

public class ClientHttpConnectorFactory {
    private static final boolean REACTOR_NETTY_PRESENT = ClientHttpConnectorFactory.isPresent("reactor.netty.http.client.HttpClient");
    private static final boolean JETTY_PRESENT = ClientHttpConnectorFactory.isPresent("org.eclipse.jetty.client.HttpClient");

    private static boolean isPresent(String ... classNames) {
        for (String className : classNames) {
            if (ClassUtils.isPresent((String)className, (ClassLoader)ClientHttpConnectorFactory.class.getClassLoader())) continue;
            return false;
        }
        return true;
    }

    public static ClientHttpConnector create(ClientOptions options, SslConfiguration sslConfiguration) {
        Assert.notNull((Object)options, (String)"ClientOptions must not be null");
        Assert.notNull((Object)sslConfiguration, (String)"SslConfiguration must not be null");
        if (REACTOR_NETTY_PRESENT) {
            return ReactorNetty.usingReactorNetty(options, sslConfiguration);
        }
        if (JETTY_PRESENT) {
            return JettyClient.usingJetty(options, sslConfiguration);
        }
        throw new IllegalStateException("No supported Reactive Http Client library available (Reactor Netty, Jetty)");
    }

    private static void configureSsl(SslConfiguration sslConfiguration, SslContextBuilder sslContextBuilder) {
        try {
            if (sslConfiguration.getTrustStoreConfiguration().isPresent()) {
                sslContextBuilder.trustManager(ClientHttpRequestFactoryFactory.createTrustManagerFactory(sslConfiguration.getTrustStoreConfiguration()));
            }
            if (sslConfiguration.getKeyStoreConfiguration().isPresent()) {
                sslContextBuilder.keyManager(ClientHttpRequestFactoryFactory.createKeyManagerFactory(sslConfiguration.getKeyStoreConfiguration(), sslConfiguration.getKeyConfiguration()));
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    static class JettyClient {
        JettyClient() {
        }

        static ClientHttpConnector usingJetty(ClientOptions options, SslConfiguration sslConfiguration) {
            try {
                return new JettyClientHttpConnector(JettyClient.configureClient(JettyClient.getHttpClient(sslConfiguration), options));
            }
            catch (IOException | GeneralSecurityException e) {
                throw new IllegalStateException(e);
            }
        }

        private static org.eclipse.jetty.client.HttpClient configureClient(org.eclipse.jetty.client.HttpClient httpClient, ClientOptions options) {
            httpClient.setConnectTimeout(options.getConnectionTimeout().toMillis());
            httpClient.setAddressResolutionTimeout(options.getConnectionTimeout().toMillis());
            return httpClient;
        }

        private static org.eclipse.jetty.client.HttpClient getHttpClient(SslConfiguration sslConfiguration) throws IOException, GeneralSecurityException {
            if (ClientHttpRequestFactoryFactory.hasSslConfiguration(sslConfiguration)) {
                SslConfiguration.KeyConfiguration keyConfiguration;
                KeyStore keyStore;
                SslContextFactory sslContextFactory = new SslContextFactory();
                if (sslConfiguration.getKeyStoreConfiguration().isPresent()) {
                    keyStore = ClientHttpRequestFactoryFactory.getKeyStore(sslConfiguration.getKeyStoreConfiguration());
                    sslContextFactory.setKeyStore(keyStore);
                }
                if (sslConfiguration.getTrustStoreConfiguration().isPresent()) {
                    keyStore = ClientHttpRequestFactoryFactory.getKeyStore(sslConfiguration.getTrustStoreConfiguration());
                    sslContextFactory.setTrustStore(keyStore);
                }
                if ((keyConfiguration = sslConfiguration.getKeyConfiguration()).getKeyAlias() != null) {
                    sslContextFactory.setCertAlias(keyConfiguration.getKeyAlias());
                }
                if (keyConfiguration.getKeyPassword() != null) {
                    sslContextFactory.setKeyManagerPassword(new String(keyConfiguration.getKeyPassword()));
                }
                return new org.eclipse.jetty.client.HttpClient(sslContextFactory);
            }
            return new org.eclipse.jetty.client.HttpClient();
        }
    }

    static class ReactorNetty {
        ReactorNetty() {
        }

        static ClientHttpConnector usingReactorNetty(ClientOptions options, SslConfiguration sslConfiguration) {
            HttpClient client = HttpClient.create();
            if (ClientHttpRequestFactoryFactory.hasSslConfiguration(sslConfiguration)) {
                SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
                ClientHttpConnectorFactory.configureSsl(sslConfiguration, sslContextBuilder);
                client = client.secure(builder -> builder.sslContext(sslContextBuilder));
            }
            client = client.tcpConfiguration(it -> it.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Math.toIntExact(options.getConnectionTimeout().toMillis())));
            return new ReactorClientHttpConnector(client);
        }
    }
}

