/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.clientcert.deploy;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.knox.gateway.clientcert.filter.ClientCertFilter;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.deploy.ProviderDeploymentContributorBase;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;

public class ClientCertDeploymentContributor
extends ProviderDeploymentContributorBase {
    private static final String CLIENTAUTH_FILTER_CLASSNAME = ClientCertFilter.class.getCanonicalName();
    public static final String ROLE = "authentication";
    public static final String NAME = "ClientCert";

    public String getRole() {
        return ROLE;
    }

    public String getName() {
        return NAME;
    }

    public void contributeFilter(DeploymentContext context, Provider provider, Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
        if (params == null) {
            params = new ArrayList<FilterParamDescriptor>();
        }
        Map providerParams = provider.getParams();
        for (Map.Entry entry : providerParams.entrySet()) {
            params.add(resource.createFilterParam().name(((String)entry.getKey()).toLowerCase(Locale.ROOT)).value((String)entry.getValue()));
        }
        resource.addFilter().name(this.getName()).role(this.getRole()).impl(CLIENTAUTH_FILTER_CLASSNAME).params(params);
    }
}

