/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.name;

import java.util.List;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.name.TooComplexDnException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Position;
import org.apache.directory.api.util.Strings;

enum FastDnParser {
    INSTANCE;


    static Dn parse(String name) throws LdapException {
        Dn dn = new Dn();
        FastDnParser.parseDn(null, name, dn);
        return dn;
    }

    static Dn parse(SchemaManager schemaManager, String name) throws LdapException {
        Dn dn = new Dn(schemaManager);
        FastDnParser.parseDn(schemaManager, name, dn);
        return dn;
    }

    static void parseDn(SchemaManager schemaManager, String name, Dn dn) throws LdapInvalidDnException {
        String normName = FastDnParser.parseDn(schemaManager, name, dn.rdns);
        dn.setUpName(name);
        dn.setNormName(normName);
    }

    static String parseDn(SchemaManager schemaManager, String name, List<Rdn> rdns) throws LdapInvalidDnException {
        StringBuilder sb;
        block5: {
            char c;
            if (name == null || name.trim().length() == 0) {
                return "";
            }
            Position pos = new Position();
            char[] chars = name.toCharArray();
            pos.start = 0;
            pos.length = chars.length;
            sb = new StringBuilder();
            block3: while (true) {
                Rdn rdn = new Rdn(schemaManager);
                FastDnParser.parseRdnInternal(schemaManager, name, pos, rdn);
                sb.append(rdn.getNormName());
                rdns.add(rdn);
                if (!FastDnParser.hasMoreChars(pos)) break block5;
                c = FastDnParser.nextChar(chars, pos, true);
                switch (c) {
                    case ',': 
                    case ';': {
                        sb.append(',');
                        continue block3;
                    }
                }
                break;
            }
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err((I18n)I18n.ERR_13601_EXPECTED_COMMA_SEMI_COLON, (Object[])new Object[]{Character.valueOf(c), pos.start}));
        }
        return sb.toString();
    }

    static void parseRdn(SchemaManager schemaManager, String name, Rdn rdn) throws LdapInvalidDnException {
        if (Strings.isEmpty((String)name)) {
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err((I18n)I18n.ERR_13602_RDN_EMPTY, (Object[])new Object[0]));
        }
        if (rdn == null) {
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err((I18n)I18n.ERR_13603_NULL_RDN, (Object[])new Object[0]));
        }
        Position pos = new Position();
        pos.start = 0;
        pos.length = name.length();
        StringBuilder sb = new StringBuilder();
        FastDnParser.parseRdnInternal(schemaManager, name, pos, rdn);
        sb.append(rdn.getNormName());
    }

    private static void parseRdnInternal(SchemaManager schemaManager, String name, Position pos, Rdn rdn) throws LdapInvalidDnException {
        StringBuilder sbNormName = new StringBuilder();
        int rdnStart = pos.start;
        char[] chars = name.toCharArray();
        FastDnParser.matchSpaces(chars, pos);
        String type = FastDnParser.matchAttributeType(chars, pos);
        FastDnParser.matchSpaces(chars, pos);
        FastDnParser.matchEquals(chars, pos);
        FastDnParser.matchSpaces(chars, pos);
        String upValue = FastDnParser.matchValue(chars, pos);
        FastDnParser.matchSpaces(chars, pos);
        String upName = name.substring(rdnStart, pos.start);
        Ava ava = new Ava(schemaManager, type, upValue);
        rdn.addAVA(schemaManager, ava);
        if (schemaManager != null) {
            AttributeType attributeType = ava.getAttributeType();
            if (attributeType != null) {
                sbNormName.append(ava.getNormType());
                sbNormName.append('=');
                sbNormName.append(ava.getValue().getNormalized());
            } else {
                sbNormName.append(type);
                sbNormName.append('=');
                sbNormName.append(upValue);
            }
        } else {
            sbNormName.append(type);
            sbNormName.append('=');
            sbNormName.append(upValue);
        }
        rdn.setUpName(upName);
        rdn.setNormName(sbNormName.toString());
        rdn.hashCode();
    }

    private static void matchSpaces(char[] name, Position pos) throws LdapInvalidDnException {
        while (FastDnParser.hasMoreChars(pos)) {
            char c = FastDnParser.nextChar(name, pos, true);
            if (c == ' ') continue;
            --pos.start;
            break;
        }
    }

    private static String matchAttributeType(char[] name, Position pos) throws LdapInvalidDnException {
        char c = FastDnParser.nextChar(name, pos, false);
        switch (c) {
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                return FastDnParser.matchAttributeTypeDescr(name, pos);
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return FastDnParser.matchAttributeTypeNumericOid(name, pos);
            }
        }
        throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err((I18n)I18n.ERR_13604_START_AT_EXPECTED, (Object[])new Object[]{Character.valueOf(c), pos.start}));
    }

    private static String matchAttributeTypeDescr(char[] name, Position pos) throws LdapInvalidDnException {
        int start = pos.start;
        block5: while (FastDnParser.hasMoreChars(pos)) {
            char c = FastDnParser.nextChar(name, pos, true);
            switch (c) {
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    continue block5;
                }
                case ' ': 
                case '=': {
                    --pos.start;
                    return new String(name, start, pos.start - start);
                }
                case '.': {
                    throw TooComplexDnException.INSTANCE;
                }
            }
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err((I18n)I18n.ERR_13605_START_AT_DESCR_EXPECTED, (Object[])new Object[]{Character.valueOf(c), pos.start}));
        }
        return new String(name, start, pos.start - start);
    }

    /*
     * Unable to fully structure code
     */
    private static String matchAttributeTypeNumericOid(char[] name, Position pos) throws LdapInvalidDnException {
        dotCount = 0;
        start = pos.start;
        block14: while (true) {
            c = FastDnParser.nextChar(name, pos, true);
            switch (c) {
                case '0': {
                    c = FastDnParser.nextChar(name, pos, true);
                    switch (c) {
                        case '.': {
                            ++dotCount;
                            continue block14;
                        }
                        case ' ': 
                        case '=': {
                            --pos.start;
                            continue block14;
                        }
                    }
                    throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err((I18n)I18n.ERR_13606_EXPECTED_NUMERICOID, (Object[])new Object[]{Character.valueOf(c), pos.start}));
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    inInnerLoop = true;
                    block15: while (true) {
                        if (inInnerLoop) ** break;
                        continue block14;
                        c = FastDnParser.nextChar(name, pos, true);
                        switch (c) {
                            case ' ': 
                            case '=': {
                                inInnerLoop = false;
                                --pos.start;
                                continue block15;
                            }
                            case '.': {
                                inInnerLoop = false;
                                ++dotCount;
                                continue block15;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                continue block15;
                            }
                        }
                        break;
                    }
                    throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err((I18n)I18n.ERR_13606_EXPECTED_NUMERICOID, (Object[])new Object[]{Character.valueOf(c), pos.start}));
                }
                case ' ': 
                case '=': {
                    --pos.start;
                    if (dotCount > 0) {
                        return new String(name, start, pos.start - start);
                    }
                    throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err((I18n)I18n.ERR_13607_DOT_MISSING_IN_OID, (Object[])new Object[0]));
                }
            }
            break;
        }
        throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err((I18n)I18n.ERR_13608_START_AT_NUMERICOID_EXPECTED, (Object[])new Object[]{Character.valueOf(c), pos.start}));
    }

    private static void matchEquals(char[] name, Position pos) throws LdapInvalidDnException {
        char c = FastDnParser.nextChar(name, pos, true);
        if (c != '=') {
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err((I18n)I18n.ERR_13609_EQUAL_EXPECTED, (Object[])new Object[]{Character.valueOf(c), pos.start}));
        }
    }

    private static String matchValue(char[] name, Position pos) throws LdapInvalidDnException {
        int start = pos.start;
        int numTrailingSpaces = 0;
        block5: while (true) {
            if (!FastDnParser.hasMoreChars(pos)) {
                pos.start -= numTrailingSpaces;
                return new String(name, start, pos.start - start);
            }
            char c = FastDnParser.nextChar(name, pos, true);
            switch (c) {
                case '\"': 
                case '#': 
                case '+': 
                case '\\': {
                    throw TooComplexDnException.INSTANCE;
                }
                case ',': 
                case ';': {
                    --pos.start;
                    pos.start -= numTrailingSpaces;
                    return new String(name, start, pos.start - start);
                }
                case ' ': {
                    ++numTrailingSpaces;
                    continue block5;
                }
            }
            numTrailingSpaces = 0;
        }
    }

    private static char nextChar(char[] name, Position pos, boolean increment) throws LdapInvalidDnException {
        if (!FastDnParser.hasMoreChars(pos)) {
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err((I18n)I18n.ERR_13610_NO_MORE_CHAR_AVAILABLE, (Object[])new Object[]{pos.start}));
        }
        char c = name[pos.start];
        if (increment) {
            ++pos.start;
        }
        return c;
    }

    private static boolean hasMoreChars(Position pos) {
        return pos.start < pos.length;
    }
}

