/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

package org.apache.kylin.util;

import java.util.BitSet;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;

public class BitSetSerializer extends Serializer<BitSet> {

    @Override
    public BitSet copy(final Kryo kryo, final BitSet original) {
        final BitSet result = new BitSet();
        final int length = original.length();
        for (int i = 0; i < length; i++) {
            result.set(i, original.get(i));
        }
        return result;
    }

    @Override
    public void write(final Kryo kryo, final Output output, final BitSet bitSet) {
        final int len = bitSet.length();

        output.writeInt(len, true);

        for (int i = 0; i < len; i++) {
            output.writeBoolean(bitSet.get(i));
        }
    }

    @Override
    public BitSet read(final Kryo kryo, final Input input, final Class<BitSet> bitSetClass) {
        final int len = input.readInt(true);
        final BitSet ret = new BitSet(len);

        for (int i = 0; i < len; i++) {
            ret.set(i, input.readBoolean());
        }

        return ret;
    }
}
