/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.log4j.chainsaw.ChainsawConstants;
import org.apache.log4j.chainsaw.JTextComponentFormatter;
import org.apache.log4j.chainsaw.SmallButton;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;

public class WelcomePanel
extends JPanel {
    private Stack urlStack = new Stack();
    private final JEditorPane textInfo = new JEditorPane();
    private final URLToolbar urlToolbar = new URLToolbar();

    public WelcomePanel() {
        super(new BorderLayout());
        this.setBackground(Color.white);
        this.add((Component)this.urlToolbar, "North");
        URL helpURL = ChainsawConstants.WELCOME_URL;
        if (helpURL != null) {
            this.textInfo.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            JScrollPane pane = new JScrollPane(this.textInfo);
            pane.setBorder(null);
            this.add((Component)pane, "Center");
            try {
                this.textInfo.setEditable(false);
                this.textInfo.setPreferredSize(new Dimension(320, 240));
                this.textInfo.setPage(helpURL);
                JTextComponentFormatter.applySystemFontAndSize(this.textInfo);
                this.textInfo.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            WelcomePanel.this.urlStack.add(WelcomePanel.this.textInfo.getPage());
                            try {
                                WelcomePanel.this.textInfo.setPage(e.getURL());
                                WelcomePanel.this.urlToolbar.updateToolbar();
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void setURL(final URL url) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    WelcomePanel.this.urlStack.push(WelcomePanel.this.textInfo.getPage());
                    WelcomePanel.this.textInfo.setPage(url);
                    JTextComponentFormatter.applySystemFontAndSize(WelcomePanel.this.textInfo);
                    WelcomePanel.this.urlToolbar.updateToolbar();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public JToolBar getToolbar() {
        return this.urlToolbar;
    }

    private class URLToolbar
    extends JToolBar {
        private final Action previousAction = new AbstractAction(null, new ImageIcon(ChainsawIcons.ICON_BACK)){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WelcomePanel.this.urlStack.isEmpty()) {
                    return;
                }
                WelcomePanel.this.setURL((URL)WelcomePanel.this.urlStack.pop());
            }
        };
        private final Action homeAction = new AbstractAction(null, new ImageIcon(ChainsawIcons.ICON_HOME)){

            @Override
            public void actionPerformed(ActionEvent e) {
                WelcomePanel.this.setURL(ChainsawConstants.WELCOME_URL);
                WelcomePanel.this.urlStack.clear();
            }
        };

        private URLToolbar() {
            this.setFloatable(false);
            this.updateToolbar();
            this.previousAction.putValue("ShortDescription", "Back");
            this.homeAction.putValue("ShortDescription", "Home");
            SmallButton home = new SmallButton(this.homeAction);
            this.add(home);
            this.addSeparator();
            SmallButton previous = new SmallButton(this.previousAction);
            previous.setEnabled(false);
            this.add(previous);
            this.addSeparator();
        }

        void updateToolbar() {
            this.previousAction.setEnabled(!WelcomePanel.this.urlStack.isEmpty());
        }
    }
}

