/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response.transform;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.spatial.ShapeValues;
import org.apache.lucene.spatial.ShapeValuesSource;
import org.apache.lucene.spatial.composite.CompositeSpatialStrategy;
import org.apache.lucene.spatial.serialized.SerializedDVStrategy;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.JSONResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.response.transform.GeoFieldUpdater;
import org.apache.solr.response.transform.TransformerFactory;
import org.apache.solr.schema.AbstractSpatialFieldType;
import org.apache.solr.schema.SchemaField;
import org.locationtech.spatial4j.io.GeoJSONWriter;
import org.locationtech.spatial4j.io.ShapeWriter;

public class GeoTransformerFactory
extends TransformerFactory {
    @Override
    public DocTransformer create(final String display, SolrParams params, SolrQueryRequest req) {
        SchemaField sf;
        String fname = params.get("f", display);
        if (fname.startsWith("[") && fname.endsWith("]")) {
            fname = display.substring(1, display.length() - 1);
        }
        if ((sf = req.getSchema().getFieldOrNull(fname)) == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, this.getClass().getSimpleName() + " using unknown field: " + fname);
        }
        if (!(sf.getType() instanceof AbstractSpatialFieldType)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "GeoTransformer requested non-spatial field: " + fname + " (" + sf.getType().getClass().getSimpleName() + ")");
        }
        final GeoFieldUpdater updater = new GeoFieldUpdater();
        updater.field = fname;
        updater.display = display;
        updater.display_error = display + "_error";
        AbstractSpatialFieldType sdv = (AbstractSpatialFieldType)sf.getType();
        Object strategy = sdv.getStrategy(fname);
        Object shapes = strategy instanceof CompositeSpatialStrategy ? ((CompositeSpatialStrategy)strategy).getGeometryStrategy().makeShapeValueSource() : (strategy instanceof SerializedDVStrategy ? ((SerializedDVStrategy)strategy).makeShapeValueSource() : null);
        String writerName = params.get("w", "GeoJSON");
        updater.formats = strategy.getSpatialContext().getFormats();
        updater.writer = updater.formats.getWriter(writerName);
        if (updater.writer == null) {
            StringBuilder str = new StringBuilder();
            str.append("Unknown Spatial Writer: ").append(writerName);
            str.append(" [");
            for (ShapeWriter w : updater.formats.getWriters()) {
                str.append(w.getFormatName()).append(' ');
            }
            str.append("]");
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, str.toString());
        }
        QueryResponseWriter qw = req.getCore().getQueryResponseWriter(req);
        boolean bl = updater.isJSON = qw.getClass() == JSONResponseWriter.class && updater.writer instanceof GeoJSONWriter;
        if (shapes != null) {
            return new DocTransformer((ShapeValuesSource)shapes, updater){
                final /* synthetic */ ShapeValuesSource val$shapes;
                final /* synthetic */ GeoFieldUpdater val$updater;
                {
                    this.val$shapes = shapeValuesSource;
                    this.val$updater = geoFieldUpdater;
                }

                @Override
                public String getName() {
                    return display;
                }

                @Override
                public void transform(SolrDocument doc, int docid) throws IOException {
                    int segmentDoc;
                    int leafOrd = ReaderUtil.subIndex((int)docid, (List)this.context.getSearcher().getTopReaderContext().leaves());
                    LeafReaderContext ctx = (LeafReaderContext)this.context.getSearcher().getTopReaderContext().leaves().get(leafOrd);
                    ShapeValues values = this.val$shapes.getValues(ctx);
                    if (values.advanceExact(segmentDoc = docid - ctx.docBase)) {
                        this.val$updater.setValue(doc, values.value());
                    }
                }
            };
        }
        return new DocTransformer(){

            @Override
            public void transform(SolrDocument doc, int docid) throws IOException {
                Object val = doc.remove((Object)updater.field);
                if (val != null) {
                    updater.setValue(doc, val);
                }
            }

            @Override
            public String getName() {
                return updater.display;
            }

            @Override
            public String[] getExtraRequestFields() {
                return new String[]{updater.field};
            }
        };
    }
}

