/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.xmp;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPIterator;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.impl.ByteBuffer;
import com.adobe.xmp.options.ParseOptions;
import com.adobe.xmp.properties.XMPPropertyInfo;
import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.StringValue;
import com.drew.metadata.xmp.XmpDirectory;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;

public class XmpReader
implements JpegSegmentMetadataReader {
    @NotNull
    private static final String XMP_JPEG_PREAMBLE = "http://ns.adobe.com/xap/1.0/\u0000";
    @NotNull
    private static final String XMP_EXTENSION_JPEG_PREAMBLE = "http://ns.adobe.com/xmp/extension/\u0000";
    @NotNull
    private static final String SCHEMA_XMP_NOTES = "http://ns.adobe.com/xmp/note/";
    @NotNull
    private static final String ATTRIBUTE_EXTENDED_XMP = "xmpNote:HasExtendedXMP";
    @NotNull
    private static final ParseOptions PARSE_OPTIONS = new ParseOptions().setXMPNodesToLimit(Collections.singletonMap("photoshop:DocumentAncestors", 1000));
    private static final int EXTENDED_XMP_GUID_LENGTH = 32;
    private static final int EXTENDED_XMP_INT_LENGTH = 4;

    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Collections.singletonList(JpegSegmentType.APP1);
    }

    @Override
    public void readJpegSegments(@NotNull Iterable<byte[]> segments, @NotNull Metadata metadata, @NotNull JpegSegmentType segmentType) {
        int preambleLength = XMP_JPEG_PREAMBLE.length();
        int extensionPreambleLength = XMP_EXTENSION_JPEG_PREAMBLE.length();
        String extendedXMPGUID = null;
        byte[] extendedXMPBuffer = null;
        for (byte[] segmentBytes : segments) {
            if (segmentBytes.length >= preambleLength && (XMP_JPEG_PREAMBLE.equalsIgnoreCase(new String(segmentBytes, 0, preambleLength)) || "XMP".equalsIgnoreCase(new String(segmentBytes, 0, 3)))) {
                byte[] xmlBytes = new byte[segmentBytes.length - preambleLength];
                System.arraycopy(segmentBytes, preambleLength, xmlBytes, 0, xmlBytes.length);
                this.extract(xmlBytes, metadata);
                extendedXMPGUID = XmpReader.getExtendedXMPGUID(metadata);
                continue;
            }
            if (extendedXMPGUID == null || segmentBytes.length < extensionPreambleLength || !XMP_EXTENSION_JPEG_PREAMBLE.equalsIgnoreCase(new String(segmentBytes, 0, extensionPreambleLength))) continue;
            extendedXMPBuffer = XmpReader.processExtendedXMPChunk(metadata, segmentBytes, extendedXMPGUID, extendedXMPBuffer);
        }
        if (extendedXMPBuffer != null) {
            this.extract(extendedXMPBuffer, metadata);
        }
    }

    public void extract(@NotNull byte[] xmpBytes, @NotNull Metadata metadata) {
        this.extract(xmpBytes, metadata, null);
    }

    public void extract(@NotNull byte[] xmpBytes, @NotNull Metadata metadata, @Nullable Directory parentDirectory) {
        this.extract(xmpBytes, 0, xmpBytes.length, metadata, parentDirectory);
    }

    public void extract(@NotNull byte[] xmpBytes, int offset, int length, @NotNull Metadata metadata, @Nullable Directory parentDirectory) {
        XmpDirectory directory = new XmpDirectory();
        if (parentDirectory != null) {
            directory.setParent(parentDirectory);
        }
        try {
            XMPMeta xmpMeta;
            if (offset == 0 && length == xmpBytes.length) {
                xmpMeta = XMPMetaFactory.parseFromBuffer(xmpBytes, PARSE_OPTIONS);
            } else {
                ByteBuffer buffer = new ByteBuffer(xmpBytes, offset, length);
                xmpMeta = XMPMetaFactory.parse(buffer.getByteStream(), PARSE_OPTIONS);
            }
            directory.setXMPMeta(xmpMeta);
        }
        catch (XMPException e) {
            directory.addError("Error processing XMP data: " + e.getMessage());
        }
        if (!directory.isEmpty()) {
            metadata.addDirectory(directory);
        }
    }

    public void extract(@NotNull String xmpString, @NotNull Metadata metadata) {
        this.extract(xmpString, metadata, null);
    }

    public void extract(@NotNull StringValue xmpString, @NotNull Metadata metadata) {
        this.extract(xmpString.getBytes(), metadata, null);
    }

    public void extract(@NotNull String xmpString, @NotNull Metadata metadata, @Nullable Directory parentDirectory) {
        XmpDirectory directory = new XmpDirectory();
        if (parentDirectory != null) {
            directory.setParent(parentDirectory);
        }
        try {
            XMPMeta xmpMeta = XMPMetaFactory.parseFromString(xmpString, PARSE_OPTIONS);
            directory.setXMPMeta(xmpMeta);
        }
        catch (XMPException e) {
            directory.addError("Error processing XMP data: " + e.getMessage());
        }
        if (!directory.isEmpty()) {
            metadata.addDirectory(directory);
        }
    }

    @Nullable
    private static String getExtendedXMPGUID(@NotNull Metadata metadata) {
        Collection<XmpDirectory> xmpDirectories = metadata.getDirectoriesOfType(XmpDirectory.class);
        for (XmpDirectory directory : xmpDirectories) {
            XMPMeta xmpMeta = directory.getXMPMeta();
            try {
                XMPIterator itr = xmpMeta.iterator(SCHEMA_XMP_NOTES, null, null);
                if (itr == null) continue;
                while (itr.hasNext()) {
                    XMPPropertyInfo pi = (XMPPropertyInfo)itr.next();
                    if (!ATTRIBUTE_EXTENDED_XMP.equals(pi.getPath())) continue;
                    return pi.getValue();
                }
            }
            catch (XMPException xMPException) {
            }
        }
        return null;
    }

    @Nullable
    private static byte[] processExtendedXMPChunk(@NotNull Metadata metadata, @NotNull byte[] segmentBytes, @NotNull String extendedXMPGUID, @Nullable byte[] extendedXMPBuffer) {
        int segmentLength = segmentBytes.length;
        int extensionPreambleLength = XMP_EXTENSION_JPEG_PREAMBLE.length();
        int totalOffset = extensionPreambleLength + 32 + 4 + 4;
        if (segmentLength >= totalOffset) {
            try {
                SequentialByteArrayReader reader = new SequentialByteArrayReader(segmentBytes);
                ((SequentialReader)reader).skip(extensionPreambleLength);
                String segmentGUID = reader.getString(32);
                if (extendedXMPGUID.equals(segmentGUID)) {
                    int fullLength = (int)reader.getUInt32();
                    int chunkOffset = (int)reader.getUInt32();
                    if (extendedXMPBuffer == null) {
                        extendedXMPBuffer = new byte[fullLength];
                    }
                    if (extendedXMPBuffer.length == fullLength) {
                        System.arraycopy(segmentBytes, totalOffset, extendedXMPBuffer, chunkOffset, segmentLength - totalOffset);
                    } else {
                        XmpDirectory directory = new XmpDirectory();
                        directory.addError(String.format("Inconsistent length for the Extended XMP buffer: %d instead of %d", fullLength, extendedXMPBuffer.length));
                        metadata.addDirectory(directory);
                    }
                }
            }
            catch (IOException ex) {
                XmpDirectory directory = new XmpDirectory();
                directory.addError(ex.getMessage());
                metadata.addDirectory(directory);
            }
        }
        return extendedXMPBuffer;
    }
}

