/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.livelink;

import com.opentext.api.LLSession;
import com.opentext.api.LLValue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.core.common.Base64;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class LLSERVER {
    public static final String _rcsid = "@(#)$Id: LLSERVER.java 988245 2010-08-23 18:39:35Z kwright $";
    private final boolean useHttp;
    private final boolean useSSL;
    private final String LLServer;
    private final int LLPort;
    private final String LLUser;
    private final String LLPwd;
    private final String httpCgiPath;
    private final String httpNtlmDomain;
    private final String httpNtlmUser;
    private final String httpNtlmPassword;
    private final IKeystoreManager keystore;
    private LLSession session = null;
    private File certFolder = null;

    public LLSERVER(boolean useHttp, boolean useSSL, String server, int port, String user, String pwd, String httpCgiPath, String httpNtlmDomain, String httpNtlmUser, String httpNtlmPassword, IKeystoreManager keystoreManager) throws ManifoldCFException {
        this.useHttp = useHttp;
        this.useSSL = useSSL;
        this.LLServer = server;
        this.LLPort = port;
        this.LLUser = user;
        this.LLPwd = pwd;
        this.httpCgiPath = httpCgiPath;
        this.httpNtlmDomain = httpNtlmDomain;
        this.httpNtlmUser = httpNtlmUser;
        this.httpNtlmPassword = httpNtlmPassword;
        this.keystore = keystoreManager;
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() throws ManifoldCFException {
        try {
            LLValue configuration;
            if (this.useHttp) {
                Object userNameAndDomain;
                boolean useNTLM;
                if (this.httpNtlmDomain != null && this.httpNtlmUser != null) {
                    useNTLM = true;
                    userNameAndDomain = this.httpNtlmDomain + "\\" + this.httpNtlmUser;
                } else {
                    useNTLM = false;
                    userNameAndDomain = this.httpNtlmUser;
                }
                configuration = new LLValue();
                configuration.setAssoc();
                configuration.add("Encoding", "UTF-8");
                configuration.add("LivelinkCGI", this.httpCgiPath);
                if (userNameAndDomain != null) {
                    configuration.add("HTTPUserName", (String)userNameAndDomain);
                    configuration.add("HTTPPassword", this.httpNtlmPassword);
                }
                if (useNTLM) {
                    configuration.add("EnableNTLM", 1);
                } else {
                    configuration.add("EnableNTLM", 0);
                }
                if (this.useSSL) {
                    configuration.add("HTTPS", 1);
                    this.createCertFolder();
                    if (this.keystore != null) {
                        String[] aliases;
                        for (String alias : aliases = this.keystore.getContents()) {
                            Certificate cert = this.keystore.getCertificate(alias);
                            byte[] certData = cert.getEncoded();
                            File fileName = new File(this.certFolder, ManifoldCF.safeFileName((String)alias) + ".cer");
                            FileOutputStream fos = new FileOutputStream(fileName);
                            try {
                                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
                                try {
                                    String certBase64 = new Base64().encodeByteArray(certData);
                                    osw.write("-----BEGIN CERTIFICATE-----\n");
                                    int index = 0;
                                    while (certBase64.length() - index > 64) {
                                        osw.write(certBase64.substring(index, index + 64) + "\n");
                                        index += 64;
                                    }
                                    osw.write(certBase64.substring(index) + "\n");
                                    osw.write("-----END CERTIFICATE-----\n");
                                }
                                finally {
                                    ((Writer)osw).flush();
                                }
                            }
                            finally {
                                fos.flush();
                                ((OutputStream)fos).close();
                            }
                        }
                    }
                    LLValue rootCACertList = new LLValue();
                    LLSession.GetCARootCerts((String)this.certFolder.toString(), (LLValue)rootCACertList);
                    configuration.add("CARootCerts", rootCACertList);
                } else {
                    configuration.add("HTTPS", 0);
                }
            } else {
                configuration = null;
            }
            this.session = new LLSession(this.LLServer, this.LLPort, "", this.LLUser, this.LLPwd, configuration);
        }
        catch (IOException e) {
            this.releaseCertFolder();
            throw new ManifoldCFException("IO Exception writing cert files: " + e.getMessage(), (Throwable)e);
        }
        catch (CertificateEncodingException e) {
            this.releaseCertFolder();
            throw new ManifoldCFException("Bad certificate: " + e.getMessage(), (Throwable)e);
        }
        catch (ManifoldCFException e) {
            this.releaseCertFolder();
            throw e;
        }
        catch (Error e) {
            this.releaseCertFolder();
            throw e;
        }
        catch (RuntimeException e) {
            this.releaseCertFolder();
            throw e;
        }
    }

    public void disconnect() {
        this.releaseCertFolder();
        this.session = null;
    }

    protected void createCertFolder() throws ManifoldCFException {
        this.certFolder = ManifoldCF.createTempDir((String)"llcrt_", (String)".d");
        ManifoldCF.addFile((File)this.certFolder);
    }

    protected void releaseCertFolder() {
        if (this.certFolder != null) {
            ManifoldCF.deleteFile((File)this.certFolder);
            this.certFolder = null;
        }
    }

    public String getHost() {
        if (this.session != null) {
            return this.session.getHost();
        }
        return null;
    }

    public int getPort() {
        if (this.session != null) {
            return this.session.getPort();
        }
        return -1;
    }

    public String getLLUser() {
        return this.LLUser;
    }

    public String getLLPwd() {
        return this.LLPwd;
    }

    public LLSession getLLSession() {
        return this.session;
    }

    public String getErrors() {
        if (this.session == null) {
            return null;
        }
        StringBuilder rval = new StringBuilder();
        if (this.session.getStatus() != 0) {
            rval.append("LAPI status code: ").append(this.session.getStatus());
        }
        if (this.session.getApiError().length() > 0) {
            if (rval.length() > 0) {
                rval.append("; ");
            }
            rval.append("LAPI error detail: ").append(this.session.getApiError());
        }
        if (this.session.getErrMsg().length() > 0) {
            if (rval.length() > 0) {
                rval.append("; ");
            }
            rval.append("LAPI error message: ").append(this.session.getErrMsg());
        }
        if (this.session.getStatusMessage().length() > 0) {
            if (rval.length() > 0) {
                rval.append("; ");
            }
            rval.append("LAPI status message: ").append(this.session.getStatusMessage());
        }
        if (rval.length() > 0) {
            return rval.toString();
        }
        return null;
    }
}

