/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.settings.InputLocation;
import org.apache.maven.api.settings.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class ActivationProperty
implements Serializable,
InputLocationTracker {
    final String name;
    final String value;
    final Map<Object, InputLocation> locations;
    final InputLocation importedFrom;

    protected ActivationProperty(Builder builder) {
        String string = builder.name != null ? builder.name : (this.name = builder.base != null ? builder.base.name : null);
        this.value = builder.value != null ? builder.value : (builder.base != null ? builder.base.value : null);
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations.get(key);
    }

    public Set<Object> getLocationKeys() {
        return this.locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return this.locations.keySet().stream();
    }

    public InputLocation getImportedFrom() {
        return this.importedFrom;
    }

    @Nonnull
    public Builder with() {
        return ActivationProperty.newBuilder(this);
    }

    @Nonnull
    public ActivationProperty withName(String name) {
        return ActivationProperty.newBuilder(this, true).name(name).build();
    }

    @Nonnull
    public ActivationProperty withValue(String value) {
        return ActivationProperty.newBuilder(this, true).value(value).build();
    }

    @Nonnull
    public static ActivationProperty newInstance() {
        return ActivationProperty.newInstance(true);
    }

    @Nonnull
    public static ActivationProperty newInstance(boolean withDefaults) {
        return ActivationProperty.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return ActivationProperty.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(ActivationProperty from) {
        return ActivationProperty.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(ActivationProperty from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        ActivationProperty base;
        String name;
        String value;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(ActivationProperty base, boolean forceCopy) {
            if (forceCopy) {
                this.name = base.name;
                this.value = base.value;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder value(String value) {
            this.value = value;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public ActivationProperty build() {
            if (!(this.base == null || this.name != null && this.name != this.base.name || this.value != null && this.value != this.base.value)) {
                return this.base;
            }
            return new ActivationProperty(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map oldlocs;
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Map.of();
            Map<Object, Object> map = oldlocs = this.base != null ? this.base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }
}

