/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.logging;

import java.util.Objects;
import org.apache.maven.api.cli.Logger;
import org.slf4j.Logger;

public class Slf4jLogger
implements org.apache.maven.api.cli.Logger {
    private final Logger logger;

    public Slf4jLogger(Logger logger) {
        this.logger = Objects.requireNonNull(logger, "logger");
    }

    public void log(Logger.Level level, String message, Throwable error) {
        Objects.requireNonNull(level, "level");
        Objects.requireNonNull(message, "message");
        switch (level) {
            case ERROR: {
                this.logger.error(message, error);
                break;
            }
            case WARN: {
                this.logger.warn(message, error);
                break;
            }
            case INFO: {
                this.logger.info(message, error);
                break;
            }
            case DEBUG: {
                this.logger.debug(message, error);
                break;
            }
            default: {
                this.logger.error("UNKNOWN LEVEL {}: {}", new Object[]{level, message, error});
            }
        }
    }
}

