/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvn;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.cli.ParseException;
import org.apache.maven.api.cli.Options;
import org.apache.maven.api.cli.mvn.MavenOptions;
import org.apache.maven.cling.invoker.BaseParser;
import org.apache.maven.cling.invoker.mvn.CommonsCliMavenOptions;
import org.apache.maven.cling.invoker.mvn.LayeredMavenOptions;
import org.apache.maven.cling.invoker.mvn.MavenInvokerRequest;

public class MavenParser
extends BaseParser {
    @Override
    protected List<Options> parseCliOptions(BaseParser.LocalContext context) {
        Path mavenConfig;
        ArrayList<Options> result = new ArrayList<Options>();
        MavenOptions cliOptions = this.parseMavenCliOptions(context.parserRequest.args());
        result.add((Options)cliOptions);
        if (cliOptions.atFile().isPresent()) {
            Path file = context.cwd.resolve((String)cliOptions.atFile().orElseThrow());
            if (Files.isRegularFile(file, new LinkOption[0])) {
                result.add((Options)this.parseMavenAtFileOptions(file));
            } else {
                throw new IllegalArgumentException("Specified file does not exists (" + String.valueOf(file) + ")");
            }
        }
        Path path = mavenConfig = context.rootDirectory != null ? context.rootDirectory.resolve(".mvn/maven.config") : null;
        if (mavenConfig != null && Files.isRegularFile(mavenConfig, new LinkOption[0])) {
            result.add((Options)this.parseMavenConfigOptions(mavenConfig));
        }
        return result;
    }

    protected MavenOptions parseMavenCliOptions(List<String> args) {
        try {
            return this.parseArgs("CLI", args);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to parse CLI arguments: " + e.getMessage(), e.getCause());
        }
    }

    protected MavenOptions parseMavenAtFileOptions(Path atFile) {
        MavenOptions mavenOptions;
        block9: {
            Stream<String> lines = Files.lines(atFile, Charset.defaultCharset());
            try {
                List<String> args = lines.filter(arg -> !arg.isEmpty() && !arg.startsWith("#")).toList();
                mavenOptions = this.parseArgs("atFile", args);
                if (lines == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Failed to parse arguments from file (" + String.valueOf(atFile) + "): " + e.getMessage(), e.getCause());
                }
                catch (IOException e) {
                    throw new IllegalStateException("Error reading config file: " + String.valueOf(atFile), e);
                }
            }
            lines.close();
        }
        return mavenOptions;
    }

    protected MavenOptions parseMavenConfigOptions(Path configFile) {
        MavenOptions mavenOptions;
        block10: {
            Stream<String> lines = Files.lines(configFile, Charset.defaultCharset());
            try {
                List<String> args = lines.filter(arg -> !arg.isEmpty() && !arg.startsWith("#")).toList();
                MavenOptions options = this.parseArgs("maven.config", args);
                if (options.goals().isPresent()) {
                    throw new IllegalArgumentException("Unrecognized entries in maven.config (" + String.valueOf(configFile) + ") file: " + String.valueOf(options.goals().get()));
                }
                mavenOptions = options;
                if (lines == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Failed to parse arguments from maven.config file (" + String.valueOf(configFile) + "): " + e.getMessage(), e.getCause());
                }
                catch (IOException e) {
                    throw new IllegalStateException("Error reading config file: " + String.valueOf(configFile), e);
                }
            }
            lines.close();
        }
        return mavenOptions;
    }

    protected MavenOptions parseArgs(String source, List<String> args) throws ParseException {
        return CommonsCliMavenOptions.parse(source, args.toArray(new String[0]));
    }

    protected MavenOptions emptyOptions() {
        try {
            return CommonsCliMavenOptions.parse("CLI", new String[0]);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    protected MavenInvokerRequest getInvokerRequest(BaseParser.LocalContext context) {
        return new MavenInvokerRequest(context.parserRequest, context.parsingFailed, context.cwd, context.installationDirectory, context.userHomeDirectory, context.userProperties, context.systemProperties, context.topDirectory, context.rootDirectory, context.extensions, (MavenOptions)context.options);
    }

    protected MavenOptions assembleOptions(List<Options> parsedOptions) {
        return LayeredMavenOptions.layerMavenOptions(parsedOptions);
    }
}

